/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.internal;

import java.text.DateFormat;
import java.text.NumberFormat;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.datacollection.DciValue;
import org.netxms.ui.eclipse.datacollection.Activator;

public class LastValuesLabelProvider
implements ITableLabelProvider {
    private Image[] stateImages = new Image[3];
    private boolean useMultipliers = true;

    public LastValuesLabelProvider() {
        this.stateImages[0] = Activator.getImageDescriptor("icons/active.gif").createImage();
        this.stateImages[1] = Activator.getImageDescriptor("icons/disabled.gif").createImage();
        this.stateImages[2] = Activator.getImageDescriptor("icons/unsupported.gif").createImage();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return columnIndex == 0 ? this.stateImages[((DciValue)element).getStatus()] : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.toString(((DciValue)element).getId());
            }
            case 1: {
                return ((DciValue)element).getDescription();
            }
            case 2: {
                return this.useMultipliers ? this.getValue((DciValue)element) : ((DciValue)element).getValue();
            }
            case 3: {
                return DateFormat.getDateTimeInstance(3, 3).format(((DciValue)element).getTimestamp());
            }
        }
        return null;
    }

    private String getValue(DciValue element) {
        switch (element.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                try {
                    long i = Long.parseLong(element.getValue());
                    if (i >= 10000000000L || i <= -10000000000L) {
                        return String.valueOf(Long.toString(i / 1000000000L)) + " G";
                    }
                    if (i >= 10000000L || i <= -10000000L) {
                        return String.valueOf(Long.toString(i / 1000000L)) + " M";
                    }
                    if (i >= 10000L || i <= -10000L) {
                        return String.valueOf(Long.toString(i / 1000L)) + " K";
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                return element.getValue();
            }
            case 5: {
                try {
                    double d = Double.parseDouble(element.getValue());
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    nf.setMaximumFractionDigits(2);
                    if (d >= 1.0E10 || d <= -1.0E10) {
                        return String.valueOf(nf.format(d / 1.0E9)) + " G";
                    }
                    if (d >= 1.0E7 || d <= -1.0E7) {
                        return String.valueOf(nf.format(d / 1000000.0)) + " M";
                    }
                    if (d >= 10000.0 || d <= -10000.0) {
                        return String.valueOf(nf.format(d / 1000.0)) + " K";
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                return element.getValue();
            }
        }
        return element.getValue();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        int i = 0;
        while (i < this.stateImages.length) {
            this.stateImages[i].dispose();
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean areMultipliersUsed() {
        return this.useMultipliers;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }
}

