/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.ObjectToolsCache;
import org.netxms.ui.eclipse.objecttools.views.helpers.TableContentProvider;
import org.netxms.ui.eclipse.objecttools.views.helpers.TableItemComparator;
import org.netxms.ui.eclipse.objecttools.views.helpers.TableLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TableToolResults
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.TableToolResults";
    private NXCSession session;
    private ObjectTool tool;
    private long nodeId;
    private SortableTableViewer viewer;
    private Action actionRefresh;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        this.tool = ObjectToolsCache.findTool(Long.parseLong(parts[0]));
        if (this.tool == null) {
            throw new PartInitException("Invalid tool ID");
        }
        this.nodeId = Long.parseLong(parts[1]);
        GenericObject object = this.session.findObjectById(this.nodeId);
        if (object == null || object.getObjectClass() != 2) {
            throw new PartInitException("Invalid object ID");
        }
        this.setPartName(String.valueOf(object.getObjectName()) + ": " + this.tool.getDisplayName());
    }

    public void createPartControl(Composite parent) {
        this.viewer = new SortableTableViewer(parent, 65536);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.createActions();
        this.contributeToActionBars();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                TableToolResults.this.refreshTable();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void refreshTable() {
        this.viewer.setInput(null);
        new ConsoleJob("Load data for table tool " + this.tool.getName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table table = TableToolResults.this.session.executeTableTool(TableToolResults.this.tool.getId(), TableToolResults.this.nodeId);
                new UIJob("Update table tool results"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        TableToolResults.this.updateViewer(table);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            protected String getErrorMessage() {
                return "Cannot get data for table tool " + TableToolResults.this.tool.getName();
            }
        }.start();
    }

    private void updateViewer(Table table) {
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 100);
            this.viewer.createColumns(names, widths, 0, 128);
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)("TableToolResults." + Long.toString(this.tool.getId())));
            this.viewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WidgetHelper.saveTableViewerSettings((SortableTableViewer)TableToolResults.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)("TableToolResults." + Long.toString(TableToolResults.this.tool.getId())));
                }
            });
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnFormats()));
        }
        this.viewer.setInput((Object)table);
    }
}

