/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.widgets;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.GeoLocation;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.osm.GeoLocationCache;
import org.netxms.ui.eclipse.osm.GeoLocationCacheListener;
import org.netxms.ui.eclipse.osm.tools.Area;
import org.netxms.ui.eclipse.osm.tools.MapAccessor;
import org.netxms.ui.eclipse.osm.tools.MapLoader;
import org.netxms.ui.eclipse.osm.tools.TileSet;
import org.netxms.ui.eclipse.osm.widgets.helpers.GeoMapListener;
import org.netxms.ui.eclipse.widgets.AnimatedImage;

public class GeoMapViewer
extends Canvas
implements PaintListener,
GeoLocationCacheListener,
MouseWheelListener,
MouseListener,
MouseMoveListener {
    private static final Color MAP_BACKGROUND = new Color((Device)Display.getDefault(), 255, 255, 255);
    private static final Color INFO_BLOCK_BACKGROUND = new Color((Device)Display.getDefault(), 150, 240, 88);
    private static final Color INFO_BLOCK_BORDER = new Color((Device)Display.getDefault(), 0, 0, 0);
    private static final Color INFO_BLOCK_TEXT = new Color((Device)Display.getDefault(), 0, 0, 0);
    private static final Color LABEL_BACKGROUND = new Color((Device)Display.getDefault(), 240, 254, 192);
    private static final Color LABEL_TEXT = new Color((Device)Display.getDefault(), 0, 0, 0);
    private static final Color BORDER_COLOR = new Color((Device)Display.getDefault(), 128, 128, 128);
    private static final int LABEL_ARROW_HEIGHT = 20;
    private static final int LABEL_ARROW_OFFSET = 10;
    private static final int LABEL_X_MARGIN = 4;
    private static final int LABEL_Y_MARGIN = 4;
    private static final int LABEL_SPACING = 4;
    private static final int DRAG_JITTER = 8;
    private ILabelProvider labelProvider;
    private Image currentImage = null;
    private Area coverage = null;
    private List<GenericObject> objects = new ArrayList<GenericObject>();
    private MapAccessor accessor;
    private IWorkbenchSiteProgressService siteService = null;
    private AnimatedImage waitingImage = null;
    private Point currentPoint;
    private Point dragStartPoint = null;
    private boolean loading = false;
    private Set<GeoMapListener> mapListeners = new HashSet<GeoMapListener>(0);
    private int offsetX;
    private int offsetY;

    public GeoMapViewer(Composite parent, int style) {
        super(parent, style);
        this.labelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
        this.setBackground(MAP_BACKGROUND);
        this.addPaintListener(this);
        final Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (GeoMapViewer.this.isDisposed()) {
                    return;
                }
                GeoMapViewer.this.reloadMap();
            }
        };
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GeoMapViewer.this.getDisplay().timerExec(1000, timer);
                Rectangle rect = GeoMapViewer.this.getClientArea();
                Point size = GeoMapViewer.this.waitingImage.getSize();
                GeoMapViewer.this.waitingImage.setLocation(rect.x + rect.width / 2 - size.x, rect.y + rect.height / 2 - size.y);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GeoMapViewer.this.labelProvider.dispose();
                GeoLocationCache.getInstance().removeListener(GeoMapViewer.this);
            }
        });
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseWheelListener(this);
        this.waitingImage = new AnimatedImage((Composite)this, 0);
        this.waitingImage.setVisible(false);
        GeoLocationCache.getInstance().addListener(this);
    }

    public void addMapListener(GeoMapListener listener) {
        this.mapListeners.add(listener);
    }

    public void removeMapListener(GeoMapListener listener) {
        this.mapListeners.remove(listener);
    }

    private void notifyOnZoomChange() {
        for (GeoMapListener listener : this.mapListeners) {
            listener.onZoom(this.accessor.getZoom());
        }
    }

    private void notifyOnPositionChange() {
        for (GeoMapListener listener : this.mapListeners) {
            listener.onPan(this.accessor.getCenterPoint());
        }
    }

    public void showMap(MapAccessor accessor) {
        this.accessor = new MapAccessor(accessor);
        this.reloadMap();
    }

    public void showMap(double lat, double lon, int zoom) {
        this.showMap(new MapAccessor(lat, lon, zoom));
    }

    private void reloadMap() {
        Rectangle rect = this.getClientArea();
        this.accessor.setMapWidth(rect.width);
        this.accessor.setMapHeight(rect.height);
        if (this.currentImage != null) {
            this.currentImage.dispose();
        }
        this.currentImage = null;
        this.loading = true;
        this.redraw();
        this.waitingImage.setVisible(true);
        try {
            this.waitingImage.setImage(new URL("platform:/plugin/org.netxms.ui.eclipse.library/icons/loading.gif"));
        }
        catch (MalformedURLException malformedURLException) {}
        if (!this.accessor.isValid()) {
            return;
        }
        final Point mapSize = new Point(this.accessor.getMapWidth(), this.accessor.getMapHeight());
        final GeoLocation centerPoint = this.accessor.getCenterPoint();
        Job job = new Job("Download map image"){

            protected IStatus run(IProgressMonitor monitor) {
                final TileSet tiles = MapLoader.getAllTiles(mapSize, centerPoint, 0, GeoMapViewer.this.accessor.getZoom());
                new UIJob("Redraw map"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (tiles != null) {
                            GeoMapViewer.this.drawTiles(tiles);
                            tiles.dispose();
                        }
                        Point mapSize = new Point(((GeoMapViewer)(this).GeoMapViewer.this).currentImage.getImageData().width, ((GeoMapViewer)(this).GeoMapViewer.this).currentImage.getImageData().height);
                        GeoMapViewer.this.coverage = GeoLocationCache.calculateCoverage(mapSize, GeoMapViewer.this.accessor.getCenterPoint(), 0, GeoMapViewer.this.accessor.getZoom());
                        GeoMapViewer.this.objects = GeoLocationCache.getInstance().getObjectsInArea(GeoMapViewer.this.coverage);
                        GeoMapViewer.this.waitingImage.setImage(null);
                        GeoMapViewer.this.waitingImage.setVisible(false);
                        GeoMapViewer.this.redraw();
                        GeoMapViewer.this.loading = false;
                        return Status.OK_STATUS;
                    }
                }.schedule();
                return Status.OK_STATUS;
            }
        };
        if (this.siteService != null) {
            this.siteService.schedule(job, 0L, true);
        } else {
            job.schedule();
        }
    }

    private void drawTiles(TileSet tileSet) {
        if (this.currentImage != null) {
            this.currentImage.dispose();
        }
        if (tileSet == null || tileSet.tiles == null || tileSet.tiles.length == 0) {
            this.currentImage = null;
            return;
        }
        Image[][] tiles = tileSet.tiles;
        Point size = this.getSize();
        this.currentImage = new Image((Device)this.getDisplay(), size.x, size.y);
        GC gc = new GC((Drawable)this.currentImage);
        int x = tileSet.xOffset;
        int y = tileSet.yOffset;
        int i = 0;
        while (i < tiles.length) {
            int j = 0;
            while (j < tiles[i].length) {
                gc.drawImage(tiles[i][j], x, y);
                if ((x += 256) >= size.x) {
                    x = tileSet.xOffset;
                    y += 256;
                }
                ++j;
            }
            ++i;
        }
        gc.dispose();
    }

    public IWorkbenchSiteProgressService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(IWorkbenchSiteProgressService siteService) {
        this.siteService = siteService;
    }

    public void paintControl(PaintEvent e) {
        int imgH;
        int imgW;
        GC gc = e.gc;
        if (this.currentImage != null) {
            gc.drawImage(this.currentImage, -this.offsetX, -this.offsetY);
            imgW = this.currentImage.getImageData().width;
            imgH = this.currentImage.getImageData().height;
        } else {
            imgW = -1;
            imgH = -1;
        }
        if (this.dragStartPoint == null && !this.loading) {
            gc.setAntialias(1);
            gc.setTextAntialias(1);
            Point centerXY = GeoLocationCache.coordinateToDisplay(this.accessor.getCenterPoint(), this.accessor.getZoom());
            for (GenericObject object : this.objects) {
                Point virtualXY = GeoLocationCache.coordinateToDisplay(object.getGeolocation(), this.accessor.getZoom());
                int dx = virtualXY.x - centerXY.x;
                int dy = virtualXY.y - centerXY.y;
                this.drawObject(gc, imgW / 2 + dx, imgH / 2 + dy, object);
            }
            GeoLocation gl = new GeoLocation(this.accessor.getLatitude(), this.accessor.getLongitude());
            String text = gl.toString();
            Point textSize = gc.textExtent(text);
            Rectangle rect = this.getClientArea();
            rect.x = 10;
            rect.y += 10;
            rect.width = textSize.x + 10;
            rect.height = textSize.y + 8;
            gc.setAntialias(1);
            gc.setBackground(INFO_BLOCK_BACKGROUND);
            gc.setAlpha(192);
            gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.setAlpha(255);
            gc.setForeground(INFO_BLOCK_BORDER);
            gc.setLineWidth(1);
            gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.setForeground(INFO_BLOCK_TEXT);
            gc.drawText(text, rect.x + 5, rect.y + 4, true);
        }
    }

    private void drawObject(GC gc, int x, int y, GenericObject object) {
        String text = object.getObjectName();
        Image image = this.labelProvider.getImage((Object)object);
        Point textSize = gc.textExtent(text);
        Rectangle rect = new Rectangle(x - 10, y - 20 - textSize.y, textSize.x + image.getImageData().width + 8 + 4, Math.max(image.getImageData().height, textSize.y) + 8);
        gc.setBackground(LABEL_BACKGROUND);
        gc.setForeground(BORDER_COLOR);
        gc.setLineWidth(4);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.setForeground(StatusDisplayInfo.getStatusColor((int)object.getStatus()));
        gc.setLineWidth(2);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        int[] arrow = new int[]{rect.x + 10 - 4, rect.y + rect.height, x, y, rect.x + 10 + 4, rect.y + rect.height};
        gc.setLineWidth(4);
        gc.setForeground(BORDER_COLOR);
        gc.drawPolyline(arrow);
        gc.fillPolygon(arrow);
        gc.setForeground(LABEL_BACKGROUND);
        gc.setLineWidth(2);
        gc.drawLine(arrow[0], arrow[1], arrow[4], arrow[5]);
        gc.setForeground(StatusDisplayInfo.getStatusColor((int)object.getStatus()));
        gc.drawPolyline(arrow);
        gc.setForeground(LABEL_TEXT);
        gc.drawImage(image, rect.x + 4, rect.y + 4);
        gc.drawText(text, rect.x + 4 + image.getImageData().width + 4, rect.y + 4);
    }

    @Override
    public void geoLocationCacheChanged(final GenericObject object, final GeoLocation prevLocation) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GeoMapViewer.this.onCacheChange(object, prevLocation);
            }
        });
    }

    private void onCacheChange(GenericObject object, GeoLocation prevLocation) {
        GeoLocation currLocation = object.getGeolocation();
        if (currLocation.getType() != 0 && this.coverage.contains(currLocation.getLatitude(), currLocation.getLongitude()) || prevLocation != null && prevLocation.getType() != 0 && this.coverage.contains(prevLocation.getLatitude(), prevLocation.getLongitude())) {
            this.objects = GeoLocationCache.getInstance().getObjectsInArea(this.coverage);
            this.redraw();
        }
    }

    public void mouseScrolled(MouseEvent event) {
        if (this.loading) {
            return;
        }
        int zoom = this.accessor.getZoom();
        if (event.count > 0) {
            if (zoom < 18) {
                ++zoom;
            }
        } else if (zoom > 1) {
            --zoom;
        }
        if (zoom != this.accessor.getZoom()) {
            this.accessor.setZoom(zoom);
            this.reloadMap();
            this.notifyOnZoomChange();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1 && !this.loading) {
            this.dragStartPoint = new Point(e.x, e.y);
            this.setCursor(this.getDisplay().getSystemCursor(5));
        }
        this.currentPoint = new Point(e.x, e.y);
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1 && this.dragStartPoint != null) {
            if (Math.abs(this.offsetX) > 8 || Math.abs(this.offsetY) > 8) {
                Point centerXY = GeoLocationCache.coordinateToDisplay(this.accessor.getCenterPoint(), this.accessor.getZoom());
                centerXY.x += this.offsetX;
                centerXY.y += this.offsetY;
                GeoLocation geoLocation = GeoLocationCache.displayToCoordinates(centerXY, this.accessor.getZoom());
                this.accessor.setLatitude(geoLocation.getLatitude());
                this.accessor.setLongitude(geoLocation.getLongitude());
                this.reloadMap();
                this.notifyOnPositionChange();
            }
            this.offsetX = 0;
            this.offsetY = 0;
            this.dragStartPoint = null;
            this.setCursor(null);
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.dragStartPoint != null) {
            int deltaX = this.dragStartPoint.x - e.x;
            int deltaY = this.dragStartPoint.y - e.y;
            if (Math.abs(deltaX) > 8 || Math.abs(deltaY) > 8) {
                this.offsetX = deltaX;
                this.offsetY = deltaY;
                this.redraw();
            }
        }
    }

    public Point getCurrentPoint() {
        return this.currentPoint;
    }

    public GeoLocation getLocationAtPoint(Point p) {
        Point cp = GeoLocationCache.coordinateToDisplay(new GeoLocation(this.coverage.getxHigh(), this.coverage.getyLow()), this.accessor.getZoom());
        return GeoLocationCache.displayToCoordinates(new Point(cp.x + p.x, cp.y + p.y), this.accessor.getZoom());
    }
}

