/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.eventmanager.dialogs.EventSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class EventSelector
extends AbstractSelector {
    private long eventCode = 0L;

    public EventSelector(Composite parent, int style) {
        super(parent, style);
        this.setText("<none>");
    }

    protected void selectionButtonHandler() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            EventTemplate[] events = dlg.getSelectedEvents();
            if (events.length > 0) {
                this.eventCode = events[0].getCode();
                this.setText(events[0].getName());
                this.setImage(StatusDisplayInfo.getStatusImage((int)events[0].getSeverity()));
                this.getTextControl().setToolTipText(this.generateToolTipText(events[0]));
            } else {
                this.eventCode = 0L;
                this.setText("<none>");
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
        }
    }

    public long getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(long eventCode) {
        this.eventCode = eventCode;
        if (eventCode != 0L) {
            EventTemplate event = ((NXCSession)ConsoleSharedData.getSession()).findEventTemplateByCode(eventCode);
            if (event != null) {
                this.setText(event.getName());
                this.setImage(StatusDisplayInfo.getStatusImage((int)event.getSeverity()));
                this.getTextControl().setToolTipText(this.generateToolTipText(event));
            } else {
                this.setText("<unknown>");
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
        } else {
            this.setText("<none>");
            this.setImage(null);
            this.getTextControl().setToolTipText(null);
        }
    }

    private String generateToolTipText(EventTemplate event) {
        StringBuilder sb = new StringBuilder(event.getName());
        sb.append(" [");
        sb.append(event.getCode());
        sb.append("]\nSeverity: ");
        sb.append(StatusDisplayInfo.getStatusText((int)event.getSeverity()));
        sb.append("\n\n");
        sb.append(event.getMessage());
        sb.append("\n\n");
        sb.append(event.getDescription().replace("\r", ""));
        return sb.toString();
    }

    protected String getButtonToolTip() {
        return "Select event";
    }
}

