/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.PrecisionGeometry;
import org.eclipse.draw2d.geometry.PrecisionPoint;

public class Vector {
    public double x;
    public double y;
    private static final Vector NULL = new Vector(0.0, 0.0);

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector(PrecisionPoint p) {
        this.x = p.preciseX();
        this.y = p.preciseY();
    }

    public Vector(PrecisionPoint start, PrecisionPoint end) {
        this.x = end.preciseX() - start.preciseX();
        this.y = end.preciseY() - start.preciseY();
    }

    public Vector(Vector start, Vector end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public double getDissimilarity(Vector other) {
        return PrecisionGeometry.preciseAbs(this.getCrossProduct(other));
    }

    public boolean isParallelTo(Vector other) {
        return this.getDissimilarity(other) == 0.0;
    }

    public double getDotProduct(Vector other) {
        return PrecisionGeometry.preciseAdd(PrecisionGeometry.preciseMultiply(this.x, other.x), PrecisionGeometry.preciseMultiply(this.y, other.y));
    }

    public double getCrossProduct(Vector other) {
        return PrecisionGeometry.preciseSubtract(PrecisionGeometry.preciseMultiply(this.x, other.y), PrecisionGeometry.preciseMultiply(this.y, other.x));
    }

    public Vector getAdded(Vector other) {
        return new Vector(PrecisionGeometry.preciseAdd(this.x, other.x), PrecisionGeometry.preciseAdd(this.y, other.y));
    }

    public Vector getSubtracted(Vector other) {
        return new Vector(PrecisionGeometry.preciseSubtract(this.x, other.x), PrecisionGeometry.preciseSubtract(this.y, other.y));
    }

    public double getAngle(Vector other) {
        double cosAlpha = PrecisionGeometry.preciseDivide(this.getDotProduct(other), PrecisionGeometry.preciseMultiply(this.getLength(), other.getLength()));
        return Math.toDegrees(Math.acos(cosAlpha));
    }

    public Vector getAveraged(Vector other) {
        return new Vector(PrecisionGeometry.preciseDivide(PrecisionGeometry.preciseAdd(this.x, other.x), 2.0), PrecisionGeometry.preciseDivide(PrecisionGeometry.preciseAdd(this.y, other.y), 2.0));
    }

    public Vector getMultiplied(double factor) {
        return new Vector(PrecisionGeometry.preciseMultiply(this.x, factor), PrecisionGeometry.preciseMultiply(this.y, factor));
    }

    public Vector getDivided(double factor) {
        return new Vector(PrecisionGeometry.preciseDivide(this.x, factor), PrecisionGeometry.preciseDivide(this.y, factor));
    }

    public Vector getOrthogonalComplement() {
        return new Vector(PrecisionGeometry.preciseNegate(this.y), this.x);
    }

    public double getLength() {
        return Math.sqrt(this.getDotProduct(this));
    }

    public double getSimilarity(Vector other) {
        return PrecisionGeometry.preciseAbs(this.getDotProduct(other));
    }

    public boolean isOrthogonalTo(Vector other) {
        return this.getSimilarity(other) == 0.0;
    }

    public boolean isHorizontal() {
        return this.x != 0.0;
    }

    public boolean isVertical() {
        return this.y != 0.0;
    }

    public boolean isNull() {
        return this.equals(NULL);
    }

    public PrecisionPoint toPoint() {
        return new PrecisionPoint(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Vector) {
            Vector r = (Vector)obj;
            return this.x == r.x && this.y == r.y;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.x + (int)this.y;
    }
}

