/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class DecorationFigure
extends Figure {
    private static final int MARGIN_X = 4;
    private static final int MARGIN_Y = 4;
    private static final int LABEL_MARGIN = 5;
    private static final int TITLE_OFFSET = 14;
    private NetworkMapDecoration decoration;
    private MapLabelProvider labelProvider;
    private Label label;

    public DecorationFigure(NetworkMapDecoration decoration, MapLabelProvider labelProvider) {
        this.decoration = decoration;
        this.labelProvider = labelProvider;
        this.setSize(decoration.getWidth(), decoration.getHeight());
        this.label = new Label(decoration.getTitle());
        this.label.setFont(labelProvider.getTitleFont());
        this.add((IFigure)this.label);
        Dimension d = this.label.getPreferredSize();
        this.label.setSize(d.width + 10, d.height + 2);
        this.label.setLocation(new Point(14, 0));
        this.label.setBackgroundColor(ColorConverter.colorFromInt((int)decoration.getColor()));
        this.label.setForegroundColor(new Color((Device)Display.getDefault(), 255, 255, 255));
    }

    protected void paintFigure(Graphics gc) {
        switch (this.decoration.getDecorationType()) {
            case 0: {
                this.drawGroupBox(gc);
                break;
            }
            case 1: {
                this.drawImage(gc);
                break;
            }
        }
    }

    private void drawGroupBox(Graphics gc) {
        gc.setAntialias(1);
        Rectangle rect = new Rectangle(this.getBounds());
        int topMargin = this.label.getSize().height / 2;
        rect.x += 4;
        rect.y += topMargin;
        rect.width -= 8;
        rect.height -= 4 + topMargin + 1;
        gc.setBackgroundColor(ColorConverter.colorFromInt((int)this.decoration.getColor()));
        gc.setAlpha(16);
        gc.fillRoundRectangle(rect, 8, 8);
        gc.setAlpha(255);
        gc.setForegroundColor(ColorConverter.colorFromInt((int)this.decoration.getColor()));
        gc.setLineWidth(3);
        gc.setLineStyle(this.labelProvider.isElementSelected((NetworkMapElement)this.decoration) ? 3 : 1);
        gc.drawRoundRectangle(rect, 8, 8);
        gc.setBackgroundColor(ColorConverter.colorFromInt((int)this.decoration.getColor()));
        gc.fillRoundRectangle(this.label.getBounds(), 8, 8);
    }

    private void drawImage(Graphics gc) {
    }

    public boolean containsPoint(int x, int y) {
        return this.label.containsPoint(x, y);
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (!this.containsPoint(x, y)) {
            return null;
        }
        if (search.prune((IFigure)this)) {
            return null;
        }
        IFigure child = this.findDescendantAtExcluding(x, y, search);
        if (child != null) {
            return child;
        }
        if (this.label.containsPoint(x, y) && search.accept((IFigure)this)) {
            return this;
        }
        return null;
    }
}

