/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.i18n.CoreMessages;

public class ArchiveEntryOutputStream
extends RAOutputStream {
    protected ArchiveWriter writer;
    protected ArchiveEntry entry;

    ArchiveEntryOutputStream(ArchiveWriter writer, ArchiveEntry entry) {
        this.writer = writer;
        this.entry = entry;
    }

    public long getOffset() throws IOException {
        return this.entry.getPosition();
    }

    public void seek(long localPos) throws IOException {
        if (localPos < 0L) {
            throw new IOException(CoreMessages.getFormattedString("error.InvalidSeekOffset", localPos));
        }
        if (localPos > this.entry.getLength()) {
            this.entry.setLength(localPos);
        }
        this.entry.seek(localPos);
    }

    public void write(int b) throws IOException {
        this.entry.write(b);
    }

    public void writeInt(int value) throws IOException {
        this.entry.writeInt(value);
    }

    public void writeLong(long value) throws IOException {
        this.entry.writeLong(value);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.entry.write(b, off, len);
    }

    public void flush() throws IOException {
        if (this.entry != null) {
            this.entry.flush();
        }
    }

    public void close() throws IOException {
        if (this.entry != null) {
            this.writer.unregisterStream(this);
            try {
                this.flush();
            }
            finally {
                try {
                    this.entry.close();
                }
                finally {
                    this.entry = null;
                }
            }
        }
    }

    public long length() throws IOException {
        return this.entry.getLength();
    }
}

