/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.netxms.client.objects.GenericObject;

public abstract class ObjectTab {
    private ViewPart viewPart;
    private CTabFolder tabFolder;
    private CTabItem tabItem;
    private Composite clientArea;
    private GenericObject object;
    private String name;
    private int order;
    private ImageDescriptor icon;

    public void configure(IConfigurationElement ce, ViewPart viewPart) {
        this.viewPart = viewPart;
        this.name = ce.getAttribute("name");
        if (this.name == null) {
            this.name = "<noname>";
        }
        try {
            this.order = Integer.parseInt(ce.getAttribute("order"), 10);
        }
        catch (NumberFormatException numberFormatException) {
            this.order = Integer.MAX_VALUE;
        }
        String path = ce.getAttribute("icon");
        if (path != null) {
            this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)ce.getContributor().getName(), (String)path);
        }
    }

    public void create(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
        this.clientArea = new Composite((Composite)tabFolder, 0);
        this.clientArea.setLayout((Layout)new FillLayout());
        this.createTabContent(this.clientArea);
        this.clientArea.setVisible(false);
    }

    protected abstract void createTabContent(Composite var1);

    public void selected() {
        this.clientArea.moveAbove(null);
        this.clientArea.setFocus();
    }

    public boolean showForObject(GenericObject object) {
        return true;
    }

    public abstract void objectChanged(GenericObject var1);

    public void changeObject(GenericObject object) {
        this.object = object;
        this.objectChanged(object);
    }

    public void show() {
        if (this.tabItem == null) {
            int index = this.tabFolder.getItemCount();
            int i = 0;
            while (i < this.tabFolder.getItemCount()) {
                ObjectTab tab = (ObjectTab)this.tabFolder.getItem(i).getData();
                if (tab.getOrder() > this.order) {
                    index = i;
                    break;
                }
                ++i;
            }
            this.tabItem = new CTabItem(this.tabFolder, 0, index);
            this.tabItem.setText(this.name);
            if (this.icon != null) {
                this.tabItem.setImage(this.icon.createImage());
            }
            this.tabItem.setControl((Control)this.clientArea);
            this.tabItem.setData((Object)this);
            this.clientArea.setVisible(true);
        }
    }

    public String getName() {
        return this.name;
    }

    public void hide() {
        if (this.tabItem != null) {
            this.tabItem.setControl(null);
            this.tabItem.dispose();
            this.tabItem = null;
            this.clientArea.setVisible(false);
        }
    }

    public GenericObject getObject() {
        return this.object;
    }

    public int getOrder() {
        return this.order;
    }

    public ViewPart getViewPart() {
        return this.viewPart;
    }

    public void dispose() {
    }

    protected Composite getClientArea() {
        return this.clientArea;
    }

    public void refresh() {
    }
}

