/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.resources;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.ui.eclipse.console.Activator;

public final class StatusDisplayInfo {
    private static String[] statusText = new String[9];
    private static ImageDescriptor[] statusImageDesc = new ImageDescriptor[9];
    private static Image[] statusImage = new Image[9];
    private static Color[] statusColor = new Color[9];

    public static void init() {
        StatusDisplayInfo.statusText[0] = "Normal";
        StatusDisplayInfo.statusText[1] = "Warning";
        StatusDisplayInfo.statusText[2] = "Minor";
        StatusDisplayInfo.statusText[3] = "Major";
        StatusDisplayInfo.statusText[4] = "Critical";
        StatusDisplayInfo.statusText[5] = "Unknown";
        StatusDisplayInfo.statusText[6] = "Unmanaged";
        StatusDisplayInfo.statusText[7] = "Disabled";
        StatusDisplayInfo.statusText[8] = "Testing";
        StatusDisplayInfo.statusImageDesc[0] = Activator.getImageDescriptor("icons/status/normal.png");
        StatusDisplayInfo.statusImageDesc[1] = Activator.getImageDescriptor("icons/status/warning.png");
        StatusDisplayInfo.statusImageDesc[2] = Activator.getImageDescriptor("icons/status/minor.png");
        StatusDisplayInfo.statusImageDesc[3] = Activator.getImageDescriptor("icons/status/major.png");
        StatusDisplayInfo.statusImageDesc[4] = Activator.getImageDescriptor("icons/status/critical.png");
        StatusDisplayInfo.statusImageDesc[5] = Activator.getImageDescriptor("icons/status/unknown.png");
        StatusDisplayInfo.statusImageDesc[6] = Activator.getImageDescriptor("icons/status/unmanaged.png");
        StatusDisplayInfo.statusImageDesc[7] = Activator.getImageDescriptor("icons/status/disabled.png");
        StatusDisplayInfo.statusImageDesc[8] = Activator.getImageDescriptor("icons/status/testing.png");
        int i = 0;
        while (i < statusImageDesc.length) {
            StatusDisplayInfo.statusImage[i] = statusImageDesc[i].createImage();
            ++i;
        }
        Display display = Display.getDefault();
        StatusDisplayInfo.statusColor[0] = new Color((Device)display, 0, 192, 0);
        StatusDisplayInfo.statusColor[1] = new Color((Device)display, 0, 255, 255);
        StatusDisplayInfo.statusColor[2] = new Color((Device)display, 231, 226, 0);
        StatusDisplayInfo.statusColor[3] = new Color((Device)display, 255, 128, 0);
        StatusDisplayInfo.statusColor[4] = new Color((Device)display, 192, 0, 0);
        StatusDisplayInfo.statusColor[5] = new Color((Device)display, 0, 0, 128);
        StatusDisplayInfo.statusColor[6] = new Color((Device)display, 192, 192, 192);
        StatusDisplayInfo.statusColor[7] = new Color((Device)display, 128, 64, 0);
        StatusDisplayInfo.statusColor[8] = new Color((Device)display, 255, 128, 255);
    }

    public static String getStatusText(int severity) {
        try {
            return statusText[severity];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "<unknown>";
        }
    }

    public static ImageDescriptor getStatusImageDescriptor(int severity) {
        try {
            return statusImageDesc[severity];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public static Image getStatusImage(int severity) {
        try {
            return statusImage[severity];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public static Color getStatusColor(int severity) {
        try {
            return statusColor[severity];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }
}

