/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerFile;
import org.netxms.ui.eclipse.filemanager.dialogs.helpers.ServerFileComparator;
import org.netxms.ui.eclipse.filemanager.dialogs.helpers.ServerFileLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SelectServerFileDialog
extends Dialog {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_SIZE = 1;
    public static final int COLUMN_MODTIME = 2;
    private SortableTableViewer viewer;
    private ServerFile[] selectedFiles;

    public SelectServerFileDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select File on Server");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        String[] names = new String[]{"Name", "Size", "Modified"};
        int[] widths = new int[]{200, 100, 150};
        this.viewer = new SortableTableViewer(dialogArea, names, widths, 0, 1024, 67584);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerFileLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerFileComparator());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 450;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectServerFileDialog.this.okPressed();
            }
        });
        new ConsoleJob("Get server file list", null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final ServerFile[] files = ((NXCSession)ConsoleSharedData.getSession()).listServerFiles();
                new UIJob("Update file list"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        SelectServerFileDialog.this.viewer.setInput((Object)files);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            protected String getErrorMessage() {
                return "Cannot get file store content";
            }
        }.start();
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select file from the list");
            return;
        }
        List list = selection.toList();
        this.selectedFiles = list.toArray(new ServerFile[list.size()]);
        super.okPressed();
    }

    public ServerFile[] getSelectedFiles() {
        return this.selectedFiles;
    }
}

