/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.topology.Port;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortInfo;

public class SlotView
extends Canvas
implements PaintListener {
    private static final int HORIZONTAL_MARGIN = 20;
    private static final int VERTICAL_MARGIN = 10;
    private static final int HORIZONTAL_SPACING = 10;
    private static final int VERTICAL_SPACING = 10;
    private static final int PORT_WIDTH = 40;
    private static final int PORT_HEIGHT = 30;
    private static final Color BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 224, 224, 224);
    private static final Color HIGHLIGHT_COLOR = new Color((Device)Display.getDefault(), 64, 156, 224);
    private List<PortInfo> ports = new ArrayList<PortInfo>();
    private int rowCount = 2;
    private String slotName;
    private Point nameSize;
    private boolean portStatusVisible = true;

    public SlotView(Composite parent, int style, String slotName) {
        super(parent, style | 0x800);
        this.slotName = slotName;
        GC gc = new GC((Drawable)this.getDisplay());
        this.nameSize = gc.textExtent(slotName);
        gc.dispose();
        this.addPaintListener(this);
    }

    public void addPort(PortInfo p) {
        this.ports.add(p);
    }

    public void paintControl(PaintEvent e) {
        e.gc.drawText(this.slotName, 20, (this.getSize().y - this.nameSize.y) / 2);
        int x = 20 + this.nameSize.x + 10;
        int y = 10;
        int row = 0;
        for (PortInfo p : this.ports) {
            this.drawPort(p, x, y, e.gc);
            if (++row == this.rowCount) {
                row = 0;
                y = 10;
                x += 50;
                continue;
            }
            y += 40;
        }
    }

    private void drawPort(PortInfo p, int x, int y, GC gc) {
        String label = Integer.toString(p.getPort());
        Rectangle rect = new Rectangle(x, y, 40, 30);
        if (p.isHighlighted()) {
            gc.setBackground(HIGHLIGHT_COLOR);
            gc.fillRectangle(rect);
        } else if (this.portStatusVisible) {
            gc.setBackground(StatusDisplayInfo.getStatusColor((int)p.getStatus()));
            gc.fillRectangle(rect);
        } else {
            gc.setBackground(BACKGROUND_COLOR);
            gc.fillRectangle(rect);
        }
        gc.drawRectangle(rect);
        Point ext = gc.textExtent(label);
        gc.drawText(label, x + (40 - ext.x) / 2, y + (30 - ext.y) / 2);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point((this.ports.size() + this.rowCount - 1) / this.rowCount * 50 + 40 + this.nameSize.x, this.rowCount * 30 + (this.rowCount - 1) * 10 + 20);
    }

    public boolean isPortStatusVisible() {
        return this.portStatusVisible;
    }

    public void setPortStatusVisible(boolean portStatusVisible) {
        this.portStatusVisible = portStatusVisible;
    }

    void clearHighlight() {
        for (PortInfo pi : this.ports) {
            pi.setHighlighted(false);
        }
    }

    void addHighlight(Port p) {
        for (PortInfo pi : this.ports) {
            if (pi.getPort() != p.getPort()) continue;
            pi.setHighlighted(true);
        }
    }
}

