/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views.helpers;

import java.util.HashMap;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DciLabelProvider
implements ITableLabelProvider {
    private NXCSession session;
    private Image[] statusImages;
    private HashMap<Integer, String> originTexts = new HashMap();
    private HashMap<Integer, String> dtTexts = new HashMap();
    private HashMap<Integer, String> statusTexts = new HashMap();

    public DciLabelProvider() {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.statusImages = new Image[3];
        this.statusImages[0] = Activator.getImageDescriptor("icons/active.gif").createImage();
        this.statusImages[1] = Activator.getImageDescriptor("icons/disabled.gif").createImage();
        this.statusImages[2] = Activator.getImageDescriptor("icons/unsupported.gif").createImage();
        this.originTexts.put(1, "NetXMS Agent");
        this.originTexts.put(2, "SNMP");
        this.originTexts.put(3, "Check Point SNMP");
        this.originTexts.put(0, "Internal");
        this.originTexts.put(4, "Push");
        this.statusTexts.put(0, "Active");
        this.statusTexts.put(1, "Disabled");
        this.statusTexts.put(2, "Not supported");
        this.dtTexts.put(0, "Integer");
        this.dtTexts.put(1, "Unsigned Integer");
        this.dtTexts.put(2, "Int64");
        this.dtTexts.put(3, "Unsigned Int64");
        this.dtTexts.put(5, "Float");
        this.dtTexts.put(4, "String");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        int status = ((DataCollectionItem)element).getStatus();
        return status >= 0 && status < this.statusImages.length ? this.statusImages[status] : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DataCollectionItem dci = (DataCollectionItem)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(dci.getId());
            }
            case 1: {
                return this.originTexts.get(dci.getOrigin());
            }
            case 2: {
                return dci.getDescription();
            }
            case 3: {
                return dci.getName();
            }
            case 4: {
                return this.dtTexts.get(dci.getDataType());
            }
            case 5: {
                if (dci.isUseAdvancedSchedule()) {
                    return "custom schedule";
                }
                return Integer.toString(dci.getPollingInterval());
            }
            case 6: {
                int days = dci.getRetentionTime();
                return String.valueOf(Integer.toString(days)) + (days == 1 ? " day" : " days");
            }
            case 7: {
                return this.statusTexts.get(dci.getStatus());
            }
            case 8: {
                if (dci.getTemplateId() == 0L) {
                    return null;
                }
                GenericObject object = this.session.findObjectById(dci.getTemplateId());
                return object != null ? object.getObjectName() : "<unknown>";
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        int i = 0;
        while (i < this.statusImages.length) {
            this.statusImages[i].dispose();
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

