/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.NetXMSClientException;
import org.netxms.api.client.Session;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.User;
import org.netxms.api.client.users.UserManager;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class General
extends PropertyPage {
    private Text textName;
    private Text textFullName;
    private Text textDescription;
    private String initialName;
    private String initialFullName;
    private String initialDescription;
    private AbstractUserObject object;
    private Session session = ConsoleSharedData.getSession();

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractUserObject)this.getElement().getAdapter(AbstractUserObject.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)"Object ID", (String)Long.toString(this.object.getId()), (Object)"WidgetHelper::default_layout_data");
        this.initialName = new String(this.object.getName());
        this.textName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Login name", (String)this.initialName, (Object)"WidgetHelper::default_layout_data");
        if (this.object instanceof User) {
            this.initialFullName = new String(((User)this.object).getFullName());
            this.textFullName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Full name", (String)this.initialFullName, (Object)"WidgetHelper::default_layout_data");
        } else {
            this.initialFullName = "";
        }
        this.initialDescription = new String(this.object.getDescription());
        this.textDescription = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Description", (String)this.initialDescription, (Object)"WidgetHelper::default_layout_data");
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        String newFullName;
        final String newName = new String(this.textName.getText());
        final String newDescription = new String(this.textDescription.getText());
        String string = newFullName = this.object instanceof User ? new String(this.textFullName.getText()) : "";
        if (newName.equals(this.initialName) && newDescription.equals(this.initialDescription) && newFullName.equals(this.initialFullName)) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        new Job("Update user database object"){

            protected IStatus run(IProgressMonitor monitor) {
                Status status;
                try {
                    General.this.initialName = newName;
                    General.this.initialFullName = newFullName;
                    General.this.initialDescription = newDescription;
                    int fields = 3;
                    General.this.object.setName(newName);
                    General.this.object.setDescription(newDescription);
                    if (General.this.object instanceof User) {
                        ((User)General.this.object).setFullName(newFullName);
                        fields |= 4;
                    }
                    ((UserManager)General.this.session).modifyUserDBObject(General.this.object, fields);
                    status = Status.OK_STATUS;
                }
                catch (Exception e) {
                    status = new Status(4, "org.netxms.ui.eclipse.usermanager", e instanceof NetXMSClientException ? ((NetXMSClientException)e).getErrorCode() : 0, "Cannot change object name: " + e.getMessage(), (Throwable)e);
                }
                if (isApply) {
                    new UIJob("Update \"General\" property page"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            General.this.setValid(true);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return status;
            }
        }.schedule();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

