/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AcknowledgeAlarm
implements IObjectActionDelegate {
    private IWorkbenchPart wbPart;
    private Object[] currentSelection;

    public void run(IAction action) {
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.wbPart.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule((Job)new AcknowledgeJob(this.currentSelection), 0L, true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.currentSelection = ((IStructuredSelection)selection).toArray();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.wbPart = targetPart;
    }

    private class AcknowledgeJob
    extends Job {
        private Object[] selection;

        AcknowledgeJob(Object[] selection) {
            super("Acknowledge alarms");
            this.setUser(true);
            this.selection = selection;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status;
            monitor.beginTask("Acknowledging alarms...", this.selection.length);
            try {
                int i = 0;
                while (i < this.selection.length && !monitor.isCanceled()) {
                    if (this.selection[i] instanceof Alarm) {
                        ((NXCSession)ConsoleSharedData.getSession()).acknowledgeAlarm(((Alarm)this.selection[i]).getId());
                    }
                    monitor.worked(1);
                    ++i;
                }
                monitor.done();
                status = Status.OK_STATUS;
            }
            catch (Exception e) {
                status = new Status(4, "org.netxms.ui.eclipse.alarmviewer", e instanceof NXCException ? ((NXCException)e).getErrorCode() : 0, "Cannot acknowledge alarm: " + e.getMessage(), (Throwable)e);
            }
            return status;
        }

        public boolean belongsTo(Object family) {
            return family == "AlarmViewJob";
        }
    }
}

