/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.dialogs.CreateZoneDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class CreateZone
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private IWorkbenchPart part;
    private long parentId = -1L;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        final CreateZoneDialog dlg = new CreateZoneDialog(this.window.getShell());
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Create new zone", this.part, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                NXCObjectCreationData cd = new NXCObjectCreationData(6, dlg.getName(), CreateZone.this.parentId);
                cd.setZoneId(dlg.getZoneId());
                session.createObject(cd);
            }

            protected String getErrorMessage() {
                return "Cannot create zone object \"" + dlg.getName() + "\"";
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        this.parentId = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? ((object = ((IStructuredSelection)selection).getFirstElement()) instanceof EntireNetwork ? ((GenericObject)object).getObjectId() : -1L) : -1L;
        action.setEnabled(this.parentId != -1L);
    }
}

