/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary.shared;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.netxms.api.client.images.LibraryImage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.imagelibrary.Activator;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ImageProvider {
    private static ImageProvider instance = new ImageProvider();
    private static final Map<UUID, Image> cache = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, LibraryImage> libraryIndex = Collections.synchronizedMap(new HashMap());
    private final Image missingImage;
    private final Set<ImageUpdateListener> updateListeners;
    private List<LibraryImage> imageLibrary;

    public static ImageProvider getInstance() {
        return instance;
    }

    private ImageProvider() {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.netxms.ui.eclipse.imagelibrary", (String)"icons/missing.png");
        this.missingImage = imageDescriptor.createImage();
        this.updateListeners = new HashSet<ImageUpdateListener>();
    }

    public void addUpdateListener(ImageUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(ImageUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    public void syncMetaData() throws NXCException, IOException {
        Display display = PlatformUI.getWorkbench().getDisplay();
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        this.imageLibrary = session.getImageLibrary();
        for (LibraryImage libraryImage : this.imageLibrary) {
            libraryIndex.put(libraryImage.getGuid(), libraryImage);
            if (libraryImage.isComplete()) continue;
            try {
                LibraryImage completeLibraryImage = session.getImage(libraryImage.getGuid());
                ByteArrayInputStream stream = new ByteArrayInputStream(completeLibraryImage.getBinaryData());
                try {
                    Image image = new Image((Device)display, (InputStream)stream);
                    cache.put(completeLibraryImage.getGuid(), image);
                }
                catch (SWTException e) {
                    Activator.logError("Exception in ImageProvider.syncMetaData()", (Exception)((Object)e));
                    cache.put(completeLibraryImage.getGuid(), this.missingImage);
                }
                for (ImageUpdateListener listener : this.updateListeners) {
                    listener.imageUpdated(completeLibraryImage.getGuid());
                }
            }
            catch (Exception e) {
                Activator.logError("Exception in ImageProvider.syncMetaData()", e);
            }
        }
    }

    public Image getImage(UUID guid) {
        Image image = cache.containsKey(guid) ? cache.get(guid) : this.missingImage;
        return image;
    }

    public LibraryImage getLibraryImageObject(UUID guid) {
        return libraryIndex.get(guid);
    }

    public List<LibraryImage> getImageLibrary() {
        return this.imageLibrary;
    }
}

