/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import java.util.HashSet;
import org.netxms.base.NXCPMessage;
import org.netxms.client.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;

public class Interface
extends GenericObject {
    public static final int IF_SYNTHETIC_MASK = 1;
    public static final int IF_PHYSICAL_PORT = 2;
    public static final int PAE_STATE_UNKNOWN = 0;
    public static final int PAE_STATE_INITIALIZE = 1;
    public static final int PAE_STATE_DISCONNECTED = 2;
    public static final int PAE_STATE_CONNECTING = 3;
    public static final int PAE_STATE_AUTHENTICATING = 4;
    public static final int PAE_STATE_AUTHENTICATED = 5;
    public static final int PAE_STATE_ABORTING = 6;
    public static final int PAE_STATE_HELD = 7;
    public static final int PAE_STATE_FORCE_AUTH = 8;
    public static final int PAE_STATE_FORCE_UNAUTH = 9;
    public static final int PAE_STATE_RESTART = 10;
    public static final int BACKEND_STATE_UNKNOWN = 0;
    public static final int BACKEND_STATE_REQUEST = 1;
    public static final int BACKEND_STATE_RESPONSE = 2;
    public static final int BACKEND_STATE_SUCCESS = 3;
    public static final int BACKEND_STATE_FAIL = 4;
    public static final int BACKEND_STATE_TIMEOUT = 5;
    public static final int BACKEND_STATE_IDLE = 6;
    public static final int BACKEND_STATE_INITIALIZE = 7;
    public static final int BACKEND_STATE_IGNORE = 8;
    private static final String[] paeStateText = new String[]{"UNKNOWN", "INITIALIZE", "DISCONNECTED", "CONNECTING", "AUTHENTICATING", "AUTHENTICATED", "ABORTING", "HELD", "FORCE AUTH", "FORCE UNAUTH", "RESTART"};
    private static final String[] backendStateText = new String[]{"UNKNOWN", "REQUEST", "RESPONSE", "SUCCESS", "FAIL", "TIMEOUT", "IDLE", "INITIALIZE", "IGNORE"};
    private int flags;
    private InetAddress subnetMask;
    private int ifIndex;
    private int ifType;
    private int slot;
    private int port;
    private MacAddress macAddress;
    private int requiredPollCount;
    private long peerNodeId;
    private long peerInterfaceId;
    private long zoneId;
    private String description;
    private int dot1xPaeState;
    private int dot1xBackendState;

    public Interface(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.flags = msg.getVariableAsInteger(13L);
        this.subnetMask = msg.getVariableAsInetAddress(9L);
        this.ifIndex = msg.getVariableAsInteger(11L);
        this.ifType = msg.getVariableAsInteger(12L);
        this.slot = msg.getVariableAsInteger(367L);
        this.port = msg.getVariableAsInteger(368L);
        this.macAddress = new MacAddress(msg.getVariableAsBinary(113L));
        this.requiredPollCount = msg.getVariableAsInteger(299L);
        this.peerNodeId = msg.getVariableAsInt64(373L);
        this.peerInterfaceId = msg.getVariableAsInt64(374L);
        this.zoneId = msg.getVariableAsInt64(147L);
        this.description = msg.getVariableAsString(27L);
        this.dot1xPaeState = msg.getVariableAsInteger(403L);
        this.dot1xBackendState = msg.getVariableAsInteger(404L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getParentNode() {
        Node node = null;
        HashSet hashSet = this.parents;
        synchronized (hashSet) {
            for (Long id : this.parents) {
                GenericObject object = this.session.findObjectById(id);
                if (!(object instanceof Node)) continue;
                node = (Node)object;
                break;
            }
        }
        return node;
    }

    public InetAddress getSubnetMask() {
        return this.subnetMask;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public int getIfType() {
        return this.ifType;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public int getRequiredPollCount() {
        return this.requiredPollCount;
    }

    @Override
    public String getObjectClassName() {
        return "Interface";
    }

    public int getSlot() {
        return this.slot;
    }

    public int getPort() {
        return this.port;
    }

    public long getPeerNodeId() {
        return this.peerNodeId;
    }

    public long getPeerInterfaceId() {
        return this.peerInterfaceId;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getDescription() {
        return this.description;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getDot1xPaeState() {
        return this.dot1xPaeState;
    }

    public String getDot1xPaeStateAsText() {
        try {
            return paeStateText[this.dot1xPaeState];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return paeStateText[0];
        }
    }

    public int getDot1xBackendState() {
        return this.dot1xBackendState;
    }

    public String getDot1xBackendStateAsText() {
        try {
            return backendStateText[this.dot1xBackendState];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return backendStateText[0];
        }
    }
}

