/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views;

import java.util.Iterator;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.DciComparator;
import org.netxms.ui.eclipse.datacollection.views.helpers.DciFilter;
import org.netxms.ui.eclipse.datacollection.views.helpers.DciLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DataCollectionEditor
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.datacollection.view.data_collection_editor";
    public static final String JOB_FAMILY = "DataCollectionEditorJob";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_ORIGIN = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    public static final int COLUMN_PARAMETER = 3;
    public static final int COLUMN_DATATYPE = 4;
    public static final int COLUMN_INTERVAL = 5;
    public static final int COLUMN_RETENTION = 6;
    public static final int COLUMN_STATUS = 7;
    public static final int COLUMN_TEMPLATE = 8;
    private boolean filterEnabled = false;
    private Composite content;
    private FilterText filterText;
    private SortableTableViewer viewer;
    private NXCSession session;
    private GenericObject object;
    private DataCollectionConfiguration dciConfig = null;
    private DciFilter filter;
    private Action actionCreate;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionCopy;
    private Action actionMove;
    private Action actionConvert;
    private Action actionDuplicate;
    private Action actionActivate;
    private Action actionDisable;
    private Action actionShowFilter;
    private RefreshAction actionRefresh;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        GenericObject obj = this.session.findObjectById(Long.parseLong(site.getSecondaryId()));
        this.object = obj != null && (obj instanceof Node || obj instanceof Template) ? obj : null;
        this.setPartName("Data Collection Configuration - " + (this.object != null ? this.object.getObjectName() : "<error>"));
    }

    public void createPartControl(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataCollectionEditor.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                DataCollectionEditor.this.enableFilter(false);
            }
        });
        String[] names = new String[]{"ID", "Origin", "Description", "Parameter", "Data Type", "Polling Interval", "Retention Time", "Status", "Template"};
        int[] widths = new int[]{60, 100, 250, 200, 90, 90, 90, 100, 150};
        this.viewer = new SortableTableViewer(this.content, names, widths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DciLabelProvider());
        this.viewer.setComparator((ViewerComparator)new DciComparator((DciLabelProvider)this.viewer.getLabelProvider()));
        this.filter = new DciFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"DataCollectionEditor");
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    DataCollectionEditor.this.actionEdit.setEnabled(selection.size() == 1);
                    DataCollectionEditor.this.actionDelete.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionCopy.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionMove.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionConvert.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionDuplicate.setEnabled(selection.size() > 0);
                    Iterator it = selection.iterator();
                    boolean canActivate = false;
                    boolean canDisable = false;
                    while (!(!it.hasNext() || canActivate && canDisable)) {
                        DataCollectionItem dci = (DataCollectionItem)it.next();
                        if (dci.getStatus() != 0) {
                            canActivate = true;
                        }
                        if (dci.getStatus() == 1) continue;
                        canDisable = true;
                    }
                    DataCollectionEditor.this.actionActivate.setEnabled(canActivate);
                    DataCollectionEditor.this.actionDisable.setEnabled(canDisable);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DataCollectionEditor.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)DataCollectionEditor.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"DataCollectionEditor");
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.filterText.setCloseAction(this.actionShowFilter);
        Job job = new Job("Open data collection configuration for " + this.object.getObjectName()){

            protected IStatus run(IProgressMonitor monitor) {
                Status status;
                try {
                    DataCollectionEditor.this.dciConfig = DataCollectionEditor.this.session.openDataCollectionConfiguration(DataCollectionEditor.this.object.getObjectId());
                    DataCollectionEditor.this.dciConfig.setUserData((Object)DataCollectionEditor.this.viewer);
                    new UIJob("Update data collection configurator for " + DataCollectionEditor.this.object.getObjectName()){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    status = Status.OK_STATUS;
                }
                catch (Exception e) {
                    status = new Status(4, "org.netxms.ui.eclipse.datacollection", e instanceof NXCException ? ((NXCException)e).getErrorCode() : 0, "Cannot open data collection configuration for " + DataCollectionEditor.this.object.getObjectName() + ": " + e.getMessage(), null);
                    new UIJob("Close data collection configurator for " + DataCollectionEditor.this.object.getObjectName()){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            DataCollectionEditor.this.getViewSite().getPage().hideView((IViewPart)DataCollectionEditor.this);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return status;
            }
        };
        this.scheduleJob(job);
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.activateContext();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.datacollection.context.LastValues");
        }
    }

    private void scheduleJob(Job job) {
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCreate);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionMove);
        manager.add((IAction)this.actionConvert);
        manager.add((IAction)this.actionDuplicate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionActivate);
        manager.add((IAction)this.actionDisable);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IAction)this.actionRefresh);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionMove);
        manager.add((IAction)this.actionConvert);
        manager.add((IAction)this.actionDuplicate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionActivate);
        manager.add((IAction)this.actionDisable);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction(){

            public void run() {
                DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
            }
        };
        this.actionCreate = new Action(){

            public void run() {
                DataCollectionEditor.this.createItem();
            }
        };
        this.actionCreate.setText("&New...");
        this.actionCreate.setImageDescriptor(Activator.getImageDescriptor("icons/new.png"));
        this.actionEdit = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer);
        this.actionEdit.setText("&Edit...");
        this.actionEdit.setImageDescriptor(Activator.getImageDescriptor("icons/edit.png"));
        this.actionEdit.setEnabled(false);
        this.actionDelete = new Action(){

            public void run() {
                DataCollectionEditor.this.deleteItems();
            }
        };
        this.actionDelete.setText("&Delete");
        this.actionDelete.setImageDescriptor(Activator.getImageDescriptor("icons/delete.png"));
        this.actionDelete.setEnabled(false);
        this.actionCopy = new Action(){

            public void run() {
                DataCollectionEditor.this.copyItems(false);
            }
        };
        this.actionCopy.setText("&Copy to other node(s)...");
        this.actionCopy.setEnabled(false);
        this.actionMove = new Action(){

            public void run() {
                DataCollectionEditor.this.copyItems(true);
            }
        };
        this.actionMove.setText("&Move to other node(s)...");
        this.actionMove.setEnabled(false);
        this.actionConvert = new Action(){

            public void run() {
                DataCollectionEditor.this.convertToTemplate();
            }
        };
        this.actionConvert.setText("Convert to &template item...");
        this.actionConvert.setEnabled(false);
        this.actionDuplicate = new Action(){

            public void run() {
                DataCollectionEditor.this.duplicateItems();
            }
        };
        this.actionDuplicate.setText("D&uplicate");
        this.actionDuplicate.setEnabled(false);
        this.actionActivate = new Action(){

            public void run() {
                DataCollectionEditor.this.setItemStatus(0);
            }
        };
        this.actionActivate.setText("&Activate");
        this.actionActivate.setImageDescriptor(Activator.getImageDescriptor("icons/active.gif"));
        this.actionActivate.setEnabled(false);
        this.actionDisable = new Action(){

            public void run() {
                DataCollectionEditor.this.setItemStatus(1);
            }
        };
        this.actionDisable.setText("D&isable");
        this.actionDisable.setImageDescriptor(Activator.getImageDescriptor("icons/disabled.gif"));
        this.actionDisable.setEnabled(false);
        this.actionShowFilter = new Action("Show &filter", 2){

            public void run() {
                DataCollectionEditor.this.enableFilter(!DataCollectionEditor.this.filterEnabled);
                DataCollectionEditor.this.actionShowFilter.setChecked(DataCollectionEditor.this.filterEnabled);
            }
        };
        this.actionShowFilter.setChecked(this.filterEnabled);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        ActionHandler showFilterHandler = new ActionHandler((IAction)this.actionShowFilter);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)showFilterHandler);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                DataCollectionEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.dciConfig != null) {
            new Job("Unlock data collection configuration for " + this.object.getObjectName()){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status;
                    try {
                        DataCollectionEditor.this.dciConfig.close();
                        DataCollectionEditor.this.dciConfig = null;
                        status = Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        status = new Status(4, "org.netxms.ui.eclipse.datacollection", e instanceof NXCException ? ((NXCException)e).getErrorCode() : 0, "Cannot unlock data collection configuration for " + DataCollectionEditor.this.object.getObjectName() + ": " + e.getMessage(), null);
                    }
                    return status;
                }
            }.schedule();
        }
        super.dispose();
    }

    private void setItemStatus(final int newStatus) {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() <= 0) {
            return;
        }
        Job job = new Job("Change status of data collection items for " + this.object.getObjectName()){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status;
                long[] itemList = new long[selection.size()];
                Iterator it = selection.iterator();
                int pos = 0;
                while (it.hasNext()) {
                    DataCollectionItem dci = (DataCollectionItem)it.next();
                    itemList[pos] = dci.getId();
                    ++pos;
                }
                try {
                    DataCollectionEditor.this.dciConfig.setItemStatus(itemList, newStatus);
                    new UIJob("Update DCI list for " + DataCollectionEditor.this.object.getObjectName()){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            for (DataCollectionItem dci : selection) {
                                dci.setStatus(newStatus);
                                DataCollectionEditor.this.viewer.update((Object)dci, null);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    status = Status.OK_STATUS;
                }
                catch (Exception e) {
                    status = new Status(4, "org.netxms.ui.eclipse.datacollection", e instanceof NXCException ? ((NXCException)e).getErrorCode() : 0, "Cannot change status of data collection items for " + DataCollectionEditor.this.object.getObjectName() + ": " + e.getMessage(), null);
                }
                return status;
            }
        };
        this.scheduleJob(job);
    }

    private void deleteItems() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() <= 0) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"Delete Data Collection Items", (String)"Do you really want to delete selected data collection items?")) {
            return;
        }
        Job job = new Job("Delete data collection items for " + this.object.getObjectName()){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status;
                try {
                    for (DataCollectionItem dci : selection) {
                        DataCollectionEditor.this.dciConfig.deleteItem(dci.getId());
                    }
                    status = Status.OK_STATUS;
                }
                catch (Exception e) {
                    status = new Status(4, "org.netxms.ui.eclipse.datacollection", e instanceof NXCException ? ((NXCException)e).getErrorCode() : 0, "Cannot delete data collection items for " + DataCollectionEditor.this.object.getObjectName() + ": " + e.getMessage(), null);
                }
                new UIJob("Update DCI list for " + DataCollectionEditor.this.object.getObjectName()){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                        return Status.OK_STATUS;
                    }
                }.schedule();
                return status;
            }
        };
        this.scheduleJob(job);
    }

    private void createItem() {
        new ConsoleJob("Create new data collection item for " + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final long id = DataCollectionEditor.this.dciConfig.createItem();
                new UIJob("Open created DCI"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                        DataCollectionItem dci = DataCollectionEditor.this.dciConfig.findItem(id);
                        DataCollectionEditor.this.viewer.setSelection((ISelection)new StructuredSelection((Object)dci), true);
                        DataCollectionEditor.this.actionEdit.run();
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            protected String getErrorMessage() {
                return "Cannot create new data collection item for " + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void duplicateItems() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        final long[] dciList = new long[selection.size()];
        int i = 0;
        while (i < dciList.length && it.hasNext()) {
            dciList[i] = ((DataCollectionItem)it.next()).getId();
            ++i;
        }
        new ConsoleJob("Duplicate data collection items for " + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DataCollectionEditor.this.dciConfig.copyItems(DataCollectionEditor.this.dciConfig.getNodeId(), dciList);
                DataCollectionEditor.this.dciConfig.close();
                DataCollectionEditor.this.dciConfig.open();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot duplicate data collection item for " + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void copyItems(final boolean doMove) {
        final ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, ObjectSelectionDialog.createNodeAndTemplateSelectionFilter());
        if (dlg.open() != 0) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        final long[] dciList = new long[selection.size()];
        int i = 0;
        while (i < dciList.length && it.hasNext()) {
            dciList[i] = ((DataCollectionItem)it.next()).getId();
            ++i;
        }
        new ConsoleJob("Copy data collection items from " + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                GenericObject o;
                GenericObject[] genericObjectArray = dlg.getSelectedObjects(Node.class);
                int n = genericObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    o = genericObjectArray[n2];
                    DataCollectionEditor.this.dciConfig.copyItems(o.getObjectId(), dciList);
                    ++n2;
                }
                genericObjectArray = dlg.getSelectedObjects(Template.class);
                n = genericObjectArray.length;
                n2 = 0;
                while (n2 < n) {
                    o = genericObjectArray[n2];
                    DataCollectionEditor.this.dciConfig.copyItems(o.getObjectId(), dciList);
                    ++n2;
                }
                if (doMove) {
                    long[] lArray = dciList;
                    int n3 = dciList.length;
                    n = 0;
                    while (n < n3) {
                        long id = lArray[n];
                        DataCollectionEditor.this.dciConfig.deleteItem(id);
                        ++n;
                    }
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot copy data collection item from " + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void convertToTemplate() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, ObjectSelectionDialog.createTemplateSelectionFilter());
        if (dlg.open() != 0) {
            return;
        }
        GenericObject[] objects = dlg.getSelectedObjects(Template.class);
        if (objects.length == 0) {
            return;
        }
        final Template template = (Template)objects[0];
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        final long[] dciList = new long[selection.size()];
        int i = 0;
        while (i < dciList.length && it.hasNext()) {
            dciList[i] = ((DataCollectionItem)it.next()).getId();
            ++i;
        }
        new ConsoleJob("Convert data collection items for " + this.object.getObjectName() + " to template items", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                long id;
                monitor.beginTask("Concert DCIs to template DCIs", 4);
                boolean needApply = true;
                long[] lArray = template.getChildIdList();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    id = lArray[n2];
                    if (id == DataCollectionEditor.this.dciConfig.getNodeId()) {
                        needApply = false;
                        break;
                    }
                    ++n2;
                }
                monitor.worked(1);
                DataCollectionEditor.this.dciConfig.copyItems(template.getObjectId(), dciList);
                lArray = dciList;
                n = dciList.length;
                n2 = 0;
                while (n2 < n) {
                    id = lArray[n2];
                    DataCollectionEditor.this.dciConfig.deleteItem(id);
                    ++n2;
                }
                DataCollectionEditor.this.dciConfig.close();
                monitor.worked(1);
                if (needApply) {
                    DataCollectionEditor.this.session.applyTemplate(template.getObjectId(), DataCollectionEditor.this.dciConfig.getNodeId());
                }
                Thread.sleep(750L);
                monitor.worked(1);
                DataCollectionEditor.this.dciConfig.open();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
                monitor.done();
            }

            protected String getErrorMessage() {
                return "Cannot convert data collection item for " + DataCollectionEditor.this.object.getObjectName() + " to template item";
            }
        }.start();
    }

    private void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }
}

