/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ColorConverter {
    public static final Color WHITE = new Color((Device)Display.getDefault(), 255, 255, 255);
    public static final Color BLACK = new Color((Device)Display.getDefault(), 0, 0, 0);

    public static int rgbToInt(RGB rgb) {
        return rgb.red | rgb.green << 8 | rgb.blue << 16;
    }

    public static RGB rgbFromInt(int color) {
        return new RGB(color & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF);
    }

    public static Color colorFromInt(int rgb) {
        return new Color((Device)PlatformUI.getWorkbench().getDisplay(), rgb & 0xFF, rgb >> 8 & 0xFF, rgb >> 16);
    }

    public static Color getColorFromPreferences(IPreferenceStore store, String name) {
        return new Color((Device)PlatformUI.getWorkbench().getDisplay(), PreferenceConverter.getColor((IPreferenceStore)store, (String)name));
    }

    public static int getColorFromPreferencesAsInt(IPreferenceStore store, String name) {
        return ColorConverter.rgbToInt(PreferenceConverter.getColor((IPreferenceStore)store, (String)name));
    }

    private static float lerp(float start, float end, float amount) {
        float difference = end - start;
        float adjusted = difference * amount;
        return start + adjusted;
    }

    public static Color adjustColor(Color color, Color direction, float amount) {
        float sr = color.getRed();
        float sg = color.getGreen();
        float sb = color.getBlue();
        float dr = direction.getRed();
        float dg = direction.getGreen();
        float db = direction.getBlue();
        return new Color(color.getDevice(), (int)ColorConverter.lerp(sr, dr, amount), (int)ColorConverter.lerp(sg, dg, amount), (int)ColorConverter.lerp(sb, db, amount));
    }
}

