/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardModifyListener;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class DashboardView
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.dashboard.views.DashboardView";
    private NXCSession session;
    private Dashboard dashboard;
    private DashboardControl dbc;
    private Composite parentComposite;
    private DashboardModifyListener dbcModifyListener;
    private RefreshAction actionRefresh;
    private Action actionEditMode;
    private Action actionSave;
    private Action actionAddAlarmBrowser;
    private Action actionAddLabel;
    private Action actionAddBarChart;
    private Action actionAddPieChart;
    private Action actionAddTubeChart;
    private Action actionAddLineChart;
    private Action actionAddAvailabilityChart;
    private Action actionAddDashboard;
    private Action actionAddStatusIndicator;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.dashboard = (Dashboard)this.session.findObjectById(Long.parseLong(site.getSecondaryId()));
        if (this.dashboard == null) {
            throw new PartInitException("Dashboard object is no longer exist or is not accessible");
        }
        this.setPartName("Dashboard: " + this.dashboard.getObjectName());
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        this.dbc = new DashboardControl(parent, 0, this.dashboard, false);
        this.dbcModifyListener = new DashboardModifyListener(){

            @Override
            public void save() {
                DashboardView.this.actionSave.setEnabled(false);
                DashboardView.this.firePropertyChange(257);
            }

            @Override
            public void modify() {
                DashboardView.this.actionSave.setEnabled(true);
                DashboardView.this.firePropertyChange(257);
            }
        };
        this.dbc.setModifyListener(this.dbcModifyListener);
        this.createActions();
        this.contributeToActionBars();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                if (DashboardView.this.dbc.isModified() && !MessageDialog.openConfirm((Shell)DashboardView.this.getSite().getShell(), (String)"Refresh Dashboard", (String)"This will destroy all unsaved changes. Are you sure?")) {
                    return;
                }
                DashboardView.this.rebuildDashboard(true);
            }
        };
        this.actionSave = new Action("&Save"){

            public void run() {
                DashboardView.this.dbc.saveDashboard((IViewPart)DashboardView.this);
            }
        };
        this.actionSave.setImageDescriptor(SharedIcons.SAVE);
        this.actionSave.setEnabled(false);
        this.actionEditMode = new Action("Edit mode", 2){

            public void run() {
                DashboardView.this.dbc.setEditMode(!DashboardView.this.dbc.isEditMode());
                DashboardView.this.actionEditMode.setChecked(DashboardView.this.dbc.isEditMode());
                if (!DashboardView.this.dbc.isEditMode()) {
                    DashboardView.this.rebuildDashboard(false);
                }
            }
        };
        this.actionEditMode.setImageDescriptor(SharedIcons.EDIT);
        this.actionEditMode.setChecked(this.dbc.isEditMode());
        this.actionAddAlarmBrowser = new Action("Add &alarm browser"){

            public void run() {
                DashboardView.this.dbc.addAlarmBrowser();
            }
        };
        this.actionAddLabel = new Action("Add &label"){

            public void run() {
                DashboardView.this.dbc.addLabel();
            }
        };
        this.actionAddBarChart = new Action("Add &bar chart"){

            public void run() {
                DashboardView.this.dbc.addBarChart();
            }
        };
        this.actionAddPieChart = new Action("Add &pie chart"){

            public void run() {
                DashboardView.this.dbc.addPieChart();
            }
        };
        this.actionAddTubeChart = new Action("Add &tube chart"){

            public void run() {
                DashboardView.this.dbc.addTubeChart();
            }
        };
        this.actionAddLineChart = new Action("Add &line chart"){

            public void run() {
                DashboardView.this.dbc.addLineChart();
            }
        };
        this.actionAddAvailabilityChart = new Action("Add a&vailability chart"){

            public void run() {
                DashboardView.this.dbc.addAvailabilityChart();
            }
        };
        this.actionAddDashboard = new Action("Add embedded &dashboard"){

            public void run() {
                DashboardView.this.dbc.addEmbeddedDashboard();
            }
        };
        this.actionAddStatusIndicator = new Action("Add &status indicator"){

            public void run() {
                DashboardView.this.dbc.addStatusIndicator();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionEditMode);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAddAlarmBrowser);
        manager.add((IAction)this.actionAddLabel);
        manager.add((IAction)this.actionAddLineChart);
        manager.add((IAction)this.actionAddBarChart);
        manager.add((IAction)this.actionAddPieChart);
        manager.add((IAction)this.actionAddTubeChart);
        manager.add((IAction)this.actionAddStatusIndicator);
        manager.add((IAction)this.actionAddAvailabilityChart);
        manager.add((IAction)this.actionAddDashboard);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionEditMode);
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.dbc.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
        this.dbc.saveDashboard((IViewPart)this);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dbc.isModified();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.dbc.isModified();
    }

    private void rebuildDashboard(boolean reload) {
        if (this.dashboard == null) {
            return;
        }
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        if (reload) {
            this.dashboard = (Dashboard)((NXCSession)ConsoleSharedData.getSession()).findObjectById(this.dashboard.getObjectId(), Dashboard.class);
            if (this.dashboard != null) {
                this.dbc = new DashboardControl(this.parentComposite, 0, this.dashboard, false);
                this.parentComposite.layout(true, true);
                this.setPartName("Dashboard: " + this.dashboard.getObjectName());
                this.dbc.setModifyListener(this.dbcModifyListener);
            } else {
                this.dbc = null;
            }
        } else {
            this.dbc = new DashboardControl(this.parentComposite, 0, this.dashboard, this.dbc.getElements(), this.dbc.isModified());
            this.parentComposite.layout(true, true);
            this.dbc.setModifyListener(this.dbcModifyListener);
        }
        this.actionSave.setEnabled(this.dbc.isModified());
        this.firePropertyChange(257);
    }
}

