/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.views;

import java.io.IOException;
import java.io.InputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.netxms.api.client.scripts.Script;
import org.netxms.api.client.scripts.ScriptLibraryManager;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class ScriptEditorView
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.nxsl.views.ScriptEditorView";
    private ScriptLibraryManager scriptLibraryManager;
    private ScriptEditor editor;
    private long scriptId;
    private String scriptName;
    private RefreshAction actionRefresh;
    private Action actionSave;
    private FindReplaceAction actionFindReplace;
    private boolean modified = false;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.scriptLibraryManager = (ScriptLibraryManager)ConsoleSharedData.getSession();
        this.scriptId = Long.parseLong(site.getSecondaryId());
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.editor = new ScriptEditor(parent, 0, 768);
        this.editor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ScriptEditorView.this.modified) {
                    ScriptEditorView.this.modified = true;
                    ScriptEditorView.this.firePropertyChange(257);
                    ScriptEditorView.this.actionSave.setEnabled(true);
                    ScriptEditorView.this.actionFindReplace.update();
                }
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.reloadScript();
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    private ResourceBundle getResourceBundle() throws IOException {
        InputStream in = null;
        String resource = "resource.properties";
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        in = loader != null ? loader.getResourceAsStream(resource) : ClassLoader.getSystemResourceAsStream(resource);
        return new PropertyResourceBundle(in);
    }

    private void createActions() {
        try {
            this.actionFindReplace = new FindReplaceAction(this.getResourceBundle(), "actions.find_and_replace.", (IWorkbenchPart)this);
            IHandlerService hs = (IHandlerService)this.getSite().getService(IHandlerService.class);
            hs.activateHandler("org.eclipse.ui.edit.findReplace", (IHandler)new ActionHandler((IAction)this.actionFindReplace));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ScriptEditorView.this.reloadScript();
            }
        };
        this.actionSave = new Action(){

            public void run() {
                ScriptEditorView.this.saveScript();
            }
        };
        this.actionSave.setText("&Save");
        this.actionSave.setImageDescriptor(SharedIcons.SAVE);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionFindReplace);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void reloadScript() {
        new ConsoleJob("Loading script [" + this.scriptId + "]", (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected String getErrorMessage() {
                return "Cannot load script with ID " + ScriptEditorView.this.scriptId + " from server";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Script script = ScriptEditorView.this.scriptLibraryManager.getScript(ScriptEditorView.this.scriptId);
                new UIJob("Update script editor"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ScriptEditorView.this.scriptName = script.getName();
                        ScriptEditorView.this.setPartName("Edit Script - " + ScriptEditorView.this.scriptName);
                        ScriptEditorView.this.editor.setText(script.getSource());
                        ScriptEditorView.this.actionSave.setEnabled(false);
                        ScriptEditorView.this.actionFindReplace.update();
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }.start();
    }

    private void saveScript() {
        final String source = this.editor.getText();
        this.editor.getTextWidget().setEditable(false);
        new ConsoleJob("Saving script to library", (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected String getErrorMessage() {
                return "Cannot save script to database";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ScriptEditorView.this.doScriptSave(source, monitor);
            }
        }.start();
    }

    private void doScriptSave(String source, IProgressMonitor monitor) throws Exception {
        this.scriptLibraryManager.modifyScript(this.scriptId, this.scriptName, source);
        new UIJob("Update script editor"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!ScriptEditorView.this.editor.isDisposed()) {
                    ScriptEditorView.this.editor.getTextWidget().setEditable(true);
                    ScriptEditorView.this.actionSave.setEnabled(false);
                    ScriptEditorView.this.modified = false;
                    ScriptEditorView.this.firePropertyChange(257);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public Object getAdapter(Class adapter) {
        Object object = super.getAdapter(adapter);
        if (object != null) {
            return object;
        }
        if (adapter.equals(IFindReplaceTarget.class)) {
            return this.editor.getFindReplaceTarget();
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        String source = this.editor.getText();
        this.editor.getTextWidget().setEditable(false);
        try {
            this.doScriptSave(source, monitor);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Error", (String)("Cannot save script: " + e.getMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }
}

