/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ThresholdLabelProvider
implements ITableLabelProvider {
    private static final String[] functions = new String[]{"last(", "average(", "deviation(", "diff()", "error(", "sum("};
    private static final String[] operations = new String[]{"<", "<=", "==", ">=", ">", "!=", "like", "!like"};
    private WorkbenchLabelProvider eventLabelProvider = new WorkbenchLabelProvider();
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                int f = ((Threshold)element).getFunction();
                StringBuilder text = new StringBuilder(functions[f]);
                if (f != 3) {
                    text.append(((Threshold)element).getArg1());
                    text.append(") ");
                } else {
                    text.append(' ');
                }
                text.append(operations[((Threshold)element).getOperation()]);
                text.append(' ');
                text.append(((Threshold)element).getValue());
                return text.toString();
            }
            case 1: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((Threshold)element).getFireEvent());
                return this.eventLabelProvider.getText((Object)event);
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.eventLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

