/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.LogColumn;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;

public class AddConditionDialog
extends Dialog {
    private LogColumn column;
    private ColumnFilter filter;
    private Text likeValue;
    private ObjectSelector objectSelector;

    protected AddConditionDialog(Shell parentShell, LogColumn column) {
        super(parentShell);
        this.column = column;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Add condition");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        switch (this.column.getType()) {
            case 2: {
                this.objectSelector = new ObjectSelector(dialogArea, 0);
                this.objectSelector.setLabel("Object equals to:");
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.widthHint = 250;
                this.objectSelector.setLayoutData((Object)gd);
                break;
            }
            case 3: {
                break;
            }
            default: {
                Label label = new Label(dialogArea, 0);
                label.setText("Text equals to\n(You can use % as metacharacter to match multiple characters):");
                this.likeValue = new Text(dialogArea, 2048);
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.likeValue.setLayoutData((Object)gd);
            }
        }
        return dialogArea;
    }

    protected void okPressed() {
        switch (this.column.getType()) {
            case 2: {
                long objectId = this.objectSelector.getObjectId();
                if (objectId != 0L) {
                    this.filter = new ColumnFilter(objectId);
                    break;
                }
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select object and than press OK");
                return;
            }
            default: {
                this.filter = new ColumnFilter(this.likeValue.getText());
            }
        }
        super.okPressed();
    }

    public ColumnFilter getFilter() {
        return this.filter;
    }
}

