/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IStartup;
import org.netxms.client.NXCSession;
import org.netxms.client.snmp.MibTree;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Activator;

public class Startup
implements IStartup {
    public void earlyStartup() {
        ConsoleJob job = new ConsoleJob("Load MIB file on startup", null, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                while (ConsoleSharedData.getSession() == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                Location loc = Platform.getInstanceLocation();
                if (loc != null) {
                    File targetDir;
                    try {
                        targetDir = new File(loc.getURL().toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        targetDir = new File(loc.getURL().getPath());
                    }
                    File mibFile = new File(targetDir, "netxms.mib");
                    Date serverMibTimestamp = session.getMibFileTimestamp();
                    if (!mibFile.exists() || serverMibTimestamp.getTime() > mibFile.lastModified()) {
                        File file = session.downloadMibFile();
                        if (mibFile.exists()) {
                            mibFile.delete();
                        }
                        if (!file.renameTo(mibFile)) {
                            InputStream in = null;
                            OutputStream out = null;
                            try {
                                int len;
                                in = new FileInputStream(file);
                                out = new FileOutputStream(mibFile);
                                byte[] buffer = new byte[16384];
                                while ((len = in.read(buffer)) > 0) {
                                    out.write(buffer, 0, len);
                                }
                            }
                            finally {
                                in.close();
                                out.close();
                            }
                            file.delete();
                        }
                    }
                    MibTree mibTree = new MibTree(mibFile);
                    Activator.setMibTree(mibTree);
                }
            }

            protected String getErrorMessage() {
                return "Cannot load MIB file from server";
            }
        };
        job.setUser(false);
        job.start();
    }
}

