/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.dashboard.views.DashboardNavigator;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DashboardDynamicView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.dashboard.views.DashboardDynamicView";
    private Dashboard dashboard = null;
    private DashboardControl dbc = null;
    private ISelectionService selectionService;
    private ISelectionListener selectionListener;
    private Composite parentComposite;
    private RefreshAction actionRefresh;

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        if (this.dashboard != null) {
            this.dbc = new DashboardControl(parent, 0, this.dashboard, false);
        }
        this.createActions();
        this.contributeToActionBars();
        this.selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                Object object;
                if (part instanceof DashboardNavigator && selection instanceof IStructuredSelection && !selection.isEmpty() && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof Dashboard) {
                    DashboardDynamicView.this.setObject((Dashboard)object);
                }
            }
        };
        this.selectionService.addSelectionListener(this.selectionListener);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                DashboardDynamicView.this.rebuildDashboard();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        if (this.dbc != null) {
            this.dbc.setFocus();
        }
    }

    private void setObject(Dashboard object) {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        this.dashboard = object;
        this.dbc = new DashboardControl(this.parentComposite, 0, this.dashboard, false);
        this.parentComposite.layout();
        this.setPartName("Dashboard: " + this.dashboard.getObjectName());
    }

    private void rebuildDashboard() {
        if (this.dashboard == null) {
            return;
        }
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        this.dashboard = (Dashboard)((NXCSession)ConsoleSharedData.getSession()).findObjectById(this.dashboard.getObjectId(), Dashboard.class);
        if (this.dashboard != null) {
            this.dbc = new DashboardControl(this.parentComposite, 0, this.dashboard, false);
            this.parentComposite.layout();
            this.setPartName("Dashboard: " + this.dashboard.getObjectName());
        } else {
            this.dbc = null;
        }
    }
}

