/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectTree;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DashboardNavigator
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.dashboard.views.DashboardNavigator";
    private NXCSession session;
    private ObjectTree objectTree;

    public void createPartControl(Composite parent) {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        HashSet<Integer> classFilter = new HashSet<Integer>(2);
        classFilter.add(23);
        this.objectTree = new ObjectTree(parent, 0, 0, this.getRootObjects(classFilter), classFilter);
        this.objectTree.enableFilter(false);
        this.objectTree.getTreeViewer().expandToLevel(2);
        this.createActions();
        this.createPopupMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.objectTree.getTreeViewer());
    }

    private long[] getRootObjects(Set<Integer> classFilter) {
        GenericObject[] objects = this.session.getTopLevelObjects(classFilter);
        long[] ids = new long[objects.length];
        int i = 0;
        while (i < objects.length) {
            ids[i] = objects[i].getObjectId();
            ++i;
        }
        return ids;
    }

    private void createActions() {
    }

    private void createPopupMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                DashboardNavigator.this.fillContextMenu(mgr);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.objectTree.getTreeControl());
        this.objectTree.getTreeControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.objectTree.getTreeViewer());
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("objectcreation"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectmgmt"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectbinding"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("topology"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("datacollection"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("properties"));
        manager.add((IAction)new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.objectTree.getTreeViewer()));
    }

    public void setFocus() {
        this.objectTree.setFocus();
    }
}

