/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.StatusIndicatorConfig;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class StatusIndicatorElement
extends ElementWidget {
    private StatusIndicatorConfig config;
    private Canvas canvas;
    private Runnable refreshTimer;
    private Font font;
    private boolean greenState = false;
    private int xSize;
    private int ySize;
    private static final int MARGIN_X = 16;
    private static final int MARGIN_Y = 16;
    private static final int CIRCLE_SIZE = 36;

    protected StatusIndicatorElement(DashboardControl parent, DashboardElement element) {
        super(parent, element);
        try {
            this.config = StatusIndicatorConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new StatusIndicatorConfig();
        }
        FillLayout layout = new FillLayout();
        this.setLayout((Layout)layout);
        this.canvas = new Canvas((Composite)this, 0);
        this.canvas.setBackground(new Color((Device)this.getDisplay(), 240, 240, 240));
        this.font = new Font((Device)this.getDisplay(), "Verdana", 12, 0);
        this.calcSize(parent);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StatusIndicatorElement.this.font.dispose();
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                StatusIndicatorElement.this.drawContent(e);
            }
        });
        this.startRefreshTimer();
    }

    private void calcSize(DashboardControl parent) {
        GC gc = new GC((Drawable)parent);
        gc.setFont(this.font);
        Point textExtent = gc.textExtent(this.config.getTitle());
        gc.dispose();
        this.xSize = 84 + textExtent.x;
        this.ySize = 68;
    }

    protected void refreshData() {
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        GenericObject object = session.findObjectById(this.config.getObjectId());
        this.greenState = object != null ? object.getStatus() == 0 : false;
        this.canvas.redraw();
    }

    protected void startRefreshTimer() {
        final Display display = this.getDisplay();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (StatusIndicatorElement.this.isDisposed()) {
                    return;
                }
                StatusIndicatorElement.this.refreshData();
                display.timerExec(1000, (Runnable)this);
            }
        };
        display.timerExec(1000, this.refreshTimer);
        this.refreshData();
    }

    public void drawContent(PaintEvent e) {
        e.gc.setAntialias(1);
        Canvas canvas = (Canvas)e.widget;
        canvas.drawBackground(e.gc, 0, 0, 100, 100);
        Color bgColor = canvas.getBackground();
        Color[] redColors = new Color[]{new Color((Device)this.getDisplay(), 134, 0, 0), new Color((Device)this.getDisplay(), 192, 0, 0)};
        Color[] greenColors = new Color[]{new Color((Device)this.getDisplay(), 0, 134, 0), new Color((Device)this.getDisplay(), 0, 192, 0)};
        if (this.greenState) {
            this.drawElement(e, 16, 16, 36, bgColor, greenColors, this.config.getTitle());
        } else {
            this.drawElement(e, 16, 16, 36, bgColor, redColors, this.config.getTitle());
        }
        redColors[0].dispose();
        redColors[1].dispose();
        greenColors[0].dispose();
        greenColors[1].dispose();
        bgColor.dispose();
    }

    private void drawElement(PaintEvent e, int xMargin, int yOffset, int size, Color bgColor, Color[] circleColors, String label) {
        e.gc.setBackground(circleColors[0]);
        e.gc.fillOval(xMargin, yOffset, size, size);
        e.gc.setBackground(circleColors[1]);
        e.gc.fillOval(xMargin + 2, yOffset + 2, size - 4, size - 4);
        e.gc.setBackground(bgColor);
        e.gc.setFont(this.font);
        Point textExtent = e.gc.textExtent(label);
        e.gc.drawText(label, xMargin * 2 + size, yOffset + size / 2 - textExtent.y / 2);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.xSize, this.ySize);
    }
}

