/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ChartDimension implements Enumerator
{
    TWO_DIMENSIONAL_LITERAL(0, "TwoDimensional", "Two_Dimensional"),
    TWO_DIMENSIONAL_WITH_DEPTH_LITERAL(1, "TwoDimensionalWithDepth", "Two_Dimensional_With_Depth"),
    THREE_DIMENSIONAL_LITERAL(2, "ThreeDimensional", "Three_Dimensional");

    public static final int TWO_DIMENSIONAL = 0;
    public static final int TWO_DIMENSIONAL_WITH_DEPTH = 1;
    public static final int THREE_DIMENSIONAL = 2;
    private static final ChartDimension[] VALUES_ARRAY;
    public static final List<ChartDimension> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ChartDimension[]{TWO_DIMENSIONAL_LITERAL, TWO_DIMENSIONAL_WITH_DEPTH_LITERAL, THREE_DIMENSIONAL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ChartDimension get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChartDimension result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChartDimension getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChartDimension result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChartDimension get(int value) {
        switch (value) {
            case 0: {
                return TWO_DIMENSIONAL_LITERAL;
            }
            case 1: {
                return TWO_DIMENSIONAL_WITH_DEPTH_LITERAL;
            }
            case 2: {
                return THREE_DIMENSIONAL_LITERAL;
            }
        }
        return null;
    }

    private ChartDimension(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

