/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.layout.impl;

import java.util.Map;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.LabelLimiter;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.LayoutFactory;
import org.eclipse.birt.chart.model.layout.LayoutPackage;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.model.layout.impl.LabelBlockImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class TitleBlockImpl
extends LabelBlockImpl
implements TitleBlock {
    protected static final boolean AUTO_EDEFAULT = false;
    protected boolean auto = false;
    protected boolean autoESet;

    protected TitleBlockImpl() {
    }

    public boolean isTitle() {
        return true;
    }

    public boolean isCustom() {
        return false;
    }

    protected EClass eStaticClass() {
        return LayoutPackage.Literals.TITLE_BLOCK;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public void setAuto(boolean newAuto) {
        boolean oldAuto = this.auto;
        this.auto = newAuto;
        boolean oldAutoESet = this.autoESet;
        this.autoESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, oldAuto, this.auto, !oldAutoESet));
        }
    }

    public void unsetAuto() {
        boolean oldAuto = this.auto;
        boolean oldAutoESet = this.autoESet;
        this.auto = false;
        this.autoESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 18, oldAuto, false, oldAutoESet));
        }
    }

    public boolean isSetAuto() {
        return this.autoESet;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 18: {
                return this.isAuto();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 18: {
                this.setAuto((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 18: {
                this.unsetAuto();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 18: {
                return this.isSetAuto();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (auto: ");
        if (this.autoESet) {
            result.append(this.auto);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public static Block create() {
        TitleBlock tb = LayoutFactory.eINSTANCE.createTitleBlock();
        ((TitleBlockImpl)tb).initialize();
        return tb;
    }

    protected BoundingBox computeBox(IDisplayServer xs, RunTimeContext rtc) throws ChartException {
        Label la = goFactory.copyOf(this.getLabel());
        String sPreviousValue = la.getCaption().getValue();
        la.getCaption().setValue(rtc.externalizedMessage(sPreviousValue));
        la.setEllipsis(1);
        Map<Label, LabelLimiter> mapLimiter = rtc.getState(RunTimeContext.StateKey.LABEL_LIMITER_LOOKUP_KEY);
        LabelLimiter lbLimiter = mapLimiter.get(this.getLabel());
        lbLimiter.computeWrapping(xs, la);
        IChartComputation cComp = rtc.getState(RunTimeContext.StateKey.CHART_COMPUTATION_KEY);
        LabelLimiter lbLimiterNew = lbLimiter.limitLabelSize(cComp, xs, la);
        mapLimiter.put(this.getLabel(), lbLimiterNew);
        return lbLimiterNew.getBounding(null);
    }

    public TitleBlock copyInstance() {
        TitleBlockImpl dest = new TitleBlockImpl();
        dest.set(this);
        return dest;
    }

    protected void set(TitleBlock src) {
        super.set(src);
        this.auto = src.isAuto();
        this.autoESet = src.isSetAuto();
    }
}

