/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCException;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Container;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AutoBind
extends PropertyPage {
    private Container object;
    private Button checkboxEnable;
    private ScriptEditor filterSource;
    private boolean initialAutoBindFlag;
    private String initialAutoBindFilter;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Container)this.getElement().getAdapter(Container.class);
        if (this.object == null) {
            return dialogArea;
        }
        this.initialAutoBindFlag = this.object.isAutoBindEnabled();
        this.initialAutoBindFilter = new String(this.object.getAutoBindFilter());
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnable = new Button(dialogArea, 32);
        this.checkboxEnable.setText("Automatically bind nodes selected by filter to this container");
        this.checkboxEnable.setSelection(this.object.isAutoBindEnabled());
        this.checkboxEnable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (AutoBind.this.checkboxEnable.getSelection()) {
                    AutoBind.this.filterSource.setEnabled(true);
                    AutoBind.this.filterSource.setFocus();
                } else {
                    AutoBind.this.filterSource.setEnabled(false);
                }
            }
        });
        Label label = new Label(dialogArea, 0);
        label.setText("Filtering script");
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768);
        this.filterSource.setText(this.object.getAutoBindFilter());
        this.filterSource.setEnabled(this.object.isAutoBindEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        final boolean isAutoBindEnabled = this.checkboxEnable.getSelection();
        if (!isAutoBindEnabled && !this.initialAutoBindFlag || isAutoBindEnabled && this.initialAutoBindFlag && this.initialAutoBindFilter.equals(this.filterSource.getText())) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final String newAutoBindFilter = new String(this.filterSource.getText());
        new Job("Update auto-bind filter"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status;
                try {
                    if (AutoBind.this.object != null) {
                        NXCObjectModificationData md = new NXCObjectModificationData(AutoBind.this.object.getObjectId());
                        md.setAutoBindEnabled(isAutoBindEnabled);
                        md.setAutoBindFilter(newAutoBindFilter);
                        ((NXCSession)ConsoleSharedData.getSession()).modifyObject(md);
                    }
                    AutoBind.this.initialAutoBindFlag = isAutoBindEnabled;
                    AutoBind.this.initialAutoBindFilter = newAutoBindFilter;
                    status = Status.OK_STATUS;
                }
                catch (Exception e) {
                    status = new Status(4, "org.netxms.ui.eclipse.objectmanager", e instanceof NXCException ? ((NXCException)((Object)e)).getErrorCode() : 0, "Cannot change container automatic bind options: " + e.getMessage(), (Throwable)e);
                }
                if (isApply) {
                    new UIJob("Update \"Automatic Bind Rules\" property page"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            AutoBind.this.setValid(true);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return status;
            }
        }.schedule();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

