/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.imagelibrary.widgets.ImageSelector;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class MapAppearance
extends PropertyPage {
    private GenericObject object;
    private ImageSelector image;
    private ObjectSelector submap;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (GenericObject)this.getElement().getAdapter(GenericObject.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.image = new ImageSelector(dialogArea, 0);
        this.image.setLabel("Presentation image");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.image.setLayoutData((Object)gd);
        this.image.setImageGuid(this.object.getImage(), false);
        this.submap = new ObjectSelector(dialogArea, 0);
        this.submap.setLabel("Drill-down submap");
        this.submap.setObjectClass(NetworkMap.class);
        this.submap.setObjectId(this.object.getSubmapId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.submap.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData data = new NXCObjectModificationData(this.object.getObjectId());
        data.setImage(this.image.getImageGuid());
        data.setSubmapId(this.submap.getObjectId());
        new ConsoleJob("Update object's map appearance", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ((NXCSession)ConsoleSharedData.getSession()).modifyObject(data);
            }

            protected String getErrorMessage() {
                return "Cannot modify object " + MapAppearance.this.object.getObjectName();
            }

            protected void jobFinalize() {
                if (isApply) {
                    new UIJob("Update \"Map Appearance\" property page"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            MapAppearance.this.setValid(true);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }.schedule();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

