/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.servermanager.ServerVariable;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Activator;
import org.netxms.ui.eclipse.serverconfig.dialogs.VariableEditDialog;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ServerVariableComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ViewLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ServerConfigurationEditor
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.view.server_config";
    public static final String JOB_FAMILY = "ServerConfigJob";
    private TableViewer viewer;
    private NXCSession session;
    private Map<String, ServerVariable> varList;
    private Action actionAddVariable;
    private RefreshAction actionRefresh;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_NEED_RESTART = 2;

    public void createPartControl(Composite parent) {
        String[] names = new String[]{"Name", "Value", "Restart"};
        int[] widths = new int[]{200, 150, 80};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerVariableComparator());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ServerVariable var;
                IStructuredSelection selection = (IStructuredSelection)ServerConfigurationEditor.this.viewer.getSelection();
                if (selection != null && selection.size() == 1 && (var = (ServerVariable)selection.getFirstElement()) != null) {
                    ServerConfigurationEditor.this.editVariable(var);
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.netxms.nxmc.serverconfig.viewer");
        this.makeActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.refreshViewer();
    }

    public void refreshViewer() {
        new ConsoleJob("Load server configuration variables", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", JOB_FAMILY){

            protected String getErrorMessage() {
                return "Cannot load server configuration variables";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ServerConfigurationEditor.this.varList = ServerConfigurationEditor.this.session.getServerVariables();
                new UIJob("Initialize server configuration editor"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        Map map = ServerConfigurationEditor.this.varList;
                        synchronized (map) {
                            ServerConfigurationEditor.this.viewer.setInput((Object)ServerConfigurationEditor.this.varList.values().toArray());
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
        manager.add((IAction)this.actionAddVariable);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
        manager.add((IAction)this.actionAddVariable);
    }

    private void makeActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ServerConfigurationEditor.this.refreshViewer();
            }
        };
        this.actionAddVariable = new Action(){

            public void run() {
                ServerConfigurationEditor.this.addVariable();
            }
        };
        this.actionAddVariable.setText("Add variable");
        this.actionAddVariable.setImageDescriptor(Activator.getImageDescriptor("icons/add_variable.png"));
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ServerConfigurationEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void addVariable() {
        final VariableEditDialog dlg = new VariableEditDialog(this.getSite().getShell(), null, null);
        if (dlg.open() == 0) {
            new ConsoleJob("Create configuration variable", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", JOB_FAMILY){

                protected String getErrorMessage() {
                    return "Cannot create configuration variable";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ServerConfigurationEditor.this.session.setServerVariable(dlg.getVarName(), dlg.getVarValue());
                    ServerConfigurationEditor.this.refreshViewer();
                }
            }.start();
        }
    }

    public void editVariable(ServerVariable var) {
        final VariableEditDialog dlg = new VariableEditDialog(this.getSite().getShell(), var.getName(), var.getValue());
        if (dlg.open() == 0) {
            new ConsoleJob("Modify configuration variable", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", JOB_FAMILY){

                protected String getErrorMessage() {
                    return "Cannot create configuration variable";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ServerConfigurationEditor.this.session.setServerVariable(dlg.getVarName(), dlg.getVarValue());
                    ServerConfigurationEditor.this.refreshViewer();
                }
            }.start();
        }
    }
}

