/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.scripts.Script;
import org.netxms.api.client.scripts.ScriptLibraryManager;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.Activator;
import org.netxms.ui.eclipse.nxsl.dialogs.CreateScriptDialog;
import org.netxms.ui.eclipse.nxsl.views.helpers.ScriptComparator;
import org.netxms.ui.eclipse.nxsl.views.helpers.ScriptLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ScriptLibrary
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.nxsl.views.ScriptLibrary";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    private static final String TABLE_CONFIG_PREFIX = "ScriptLibrary";
    private ScriptLibraryManager scriptLibraryManager;
    private SortableTableViewer viewer;
    private RefreshAction actionRefresh;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;

    public void createPartControl(Composite parent) {
        this.scriptLibraryManager = (ScriptLibraryManager)ConsoleSharedData.getSession();
        parent.setLayout((Layout)new FillLayout());
        String[] names = new String[]{"ID", "Name"};
        int[] widths = new int[]{70, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ScriptLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ScriptComparator());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    ScriptLibrary.this.actionEdit.setEnabled(selection.size() == 1);
                    ScriptLibrary.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ScriptLibrary.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ScriptLibrary.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)ScriptLibrary.TABLE_CONFIG_PREFIX);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refreshScriptList();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ScriptLibrary.this.refreshScriptList();
            }
        };
        this.actionNew = new Action(){

            public void run() {
                ScriptLibrary.this.createNewScript();
            }
        };
        this.actionNew.setText("&New...");
        this.actionNew.setImageDescriptor(Activator.getImageDescriptor("icons/new.png"));
        this.actionEdit = new Action(){

            public void run() {
                ScriptLibrary.this.editScript();
            }
        };
        this.actionEdit.setText("&Edit");
        this.actionEdit.setImageDescriptor(Activator.getImageDescriptor("icons/edit.png"));
        this.actionEdit.setEnabled(false);
        this.actionDelete = new Action(){

            public void run() {
                ScriptLibrary.this.deleteScript();
            }
        };
        this.actionDelete.setText("&Delete");
        this.actionDelete.setImageDescriptor(Activator.getImageDescriptor("icons/delete.png"));
        this.actionDelete.setEnabled(false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ScriptLibrary.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
    }

    private void refreshScriptList() {
        new ConsoleJob("Loading script library", (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected String getErrorMessage() {
                return "Cannot load script library";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List library = ScriptLibrary.this.scriptLibraryManager.getScriptLibrary();
                new UIJob("Update script list"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ScriptLibrary.this.viewer.setInput((Object)library.toArray());
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }.start();
    }

    private void createNewScript() {
        final CreateScriptDialog dlg = new CreateScriptDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            new ConsoleJob("Create new script", (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    final long id = ScriptLibrary.this.scriptLibraryManager.modifyScript(0L, dlg.getName(), "");
                    new UIJob("Update script list"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            Object[] input = (Object[])ScriptLibrary.this.viewer.getInput();
                            ArrayList<Script> list = new ArrayList<Script>(input.length);
                            Object[] objectArray = input;
                            int n = input.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                list.add((Script)o);
                                ++n2;
                            }
                            Script script = new Script(id, dlg.getName(), "");
                            list.add(script);
                            ScriptLibrary.this.viewer.setInput((Object)list.toArray());
                            ScriptLibrary.this.viewer.setSelection((ISelection)new StructuredSelection((Object)script));
                            ScriptLibrary.this.actionEdit.run();
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }

                protected String getErrorMessage() {
                    return "Cannot create script";
                }
            }.start();
        }
    }

    private void editScript() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Script script = (Script)selection.getFirstElement();
        try {
            this.getSite().getPage().showView("org.netxms.ui.eclipse.nxsl.views.ScriptEditorView", Long.toString(script.getId()), 1);
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)this.getSite().getWorkbenchWindow().getShell(), (String)"Error", (String)("Cannot open script editor: " + e.getMessage()));
        }
    }

    private void deleteScript() {
        if (!MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Confirmation", (String)"Do you really want to delete selected scripts?")) {
            return;
        }
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        new ConsoleJob("Delete scripts from library", (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Script script : selection) {
                    ScriptLibrary.this.scriptLibraryManager.deleteScript(script.getId());
                }
            }

            protected void jobFinalize() {
                ScriptLibrary.this.refreshScriptList();
            }

            protected String getErrorMessage() {
                return "Cannot delete script";
            }
        }.start();
    }
}

