/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.client.datacollection.GraphSettingsChangeListener;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.charts.widgets.LineChart;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.views.helpers.GraphSettingsFactory;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.swtchart.IAxis;
import org.swtchart.LineStyle;

public class HistoricalDataView
extends ViewPart
implements ISelectionProvider,
GraphSettingsChangeListener {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.HistoryGraph";
    public static final String PREDEFINED_GRAPH_SUBID = "org.netxms.ui.eclipse.charts.predefinedGraph";
    private static final int[] presetUnits;
    private static final int[] presetRanges;
    private static final String[] presetNames;
    private static final String KEY_AUTO_REFRESH = "autoRefresh";
    private static final String KEY_REFRESH_INTERVAL = "refreshInterval";
    private static final String KEY_LOG_SCALE = "logScale";
    private static final String KEY_SHOW_LEGEND = "showLegend";
    private static final String KEY_LEGEND_POSITION = "legendPosition";
    private static final String KEY_TITLE = "title";
    private NXCSession session;
    private ArrayList<GraphItem> items = new ArrayList(1);
    private LineChart chart;
    private boolean updateInProgress = false;
    private Runnable refreshTimer;
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private GraphSettings settings = GraphSettingsFactory.createDefault();
    private RefreshAction actionRefresh;
    private Action actionAutoRefresh;
    private Action actionZoomIn;
    private Action actionZoomOut;
    private Action actionAdjustX;
    private Action actionAdjustY;
    private Action actionAdjustBoth;
    private Action actionLogScale;
    private Action actionShowLegend;
    private Action actionLegendLeft;
    private Action actionLegendRight;
    private Action actionLegendTop;
    private Action actionLegendBottom;
    private Action[] presetActions;

    static {
        int[] nArray = new int[12];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        presetUnits = nArray;
        presetRanges = new int[]{10, 30, 1, 2, 4, 12, 1, 2, 5, 7, 31, 365};
        presetNames = new String[]{"10 minutes", "30 minutes", "hour", "2 hours", "4 hours", "12 hours", "day", "2 days", "5 days", "week", "month", "year"};
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        final Display display = site.getShell().getDisplay();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (HistoricalDataView.this.chart.isDisposed()) {
                    return;
                }
                HistoricalDataView.this.updateChart();
                display.timerExec(HistoricalDataView.this.settings.getAutoRefreshInterval(), (Runnable)this);
            }
        };
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.settings.setTimeFrom(new Date(System.currentTimeMillis() - this.settings.getTimeRangeMillis()));
        this.settings.setTimeTo(new Date(System.currentTimeMillis()));
        String id = site.getSecondaryId();
        String[] fields = id.split("&");
        if (!fields[0].equals(PREDEFINED_GRAPH_SUBID)) {
            int i = 1;
            while (i < fields.length) {
                String[] subfields = fields[i].split("\\@");
                if (subfields.length == 6) {
                    try {
                        this.items.add(new GraphItem(Long.parseLong(subfields[0], 10), Long.parseLong(subfields[1], 10), Integer.parseInt(subfields[2], 10), Integer.parseInt(subfields[3], 10), URLDecoder.decode(subfields[4], "UTF-8"), URLDecoder.decode(subfields[5], "UTF-8")));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            if (this.items.size() == 1) {
                GraphItem item = this.items.get(0);
                GenericObject object = this.session.findObjectById(item.getNodeId());
                if (object != null) {
                    this.setPartName(String.valueOf(object.getObjectName()) + ": " + item.getDescription());
                }
            } else if (this.items.size() > 1) {
                GenericObject object;
                long nodeId = this.items.get(0).getNodeId();
                for (GraphItem item : this.items) {
                    if (item.getNodeId() == nodeId) continue;
                    nodeId = -1L;
                    break;
                }
                if (nodeId != -1L && (object = this.session.findObjectById(nodeId)) != null) {
                    this.setPartName(String.valueOf(object.getObjectName()) + ": historical data");
                }
            }
        }
        this.settings.setTitle(this.getPartName());
        this.settings.setItems(this.items.toArray(new GraphItem[this.items.size()]));
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        if (memento != null) {
            this.settings.setAutoRefresh(HistoricalDataView.safeCast(memento.getBoolean(KEY_AUTO_REFRESH), this.settings.isAutoRefresh()));
            this.settings.setAutoRefreshInterval(HistoricalDataView.safeCast(memento.getInteger(KEY_REFRESH_INTERVAL), this.settings.getAutoRefreshInterval()));
            this.settings.setLegendVisible(HistoricalDataView.safeCast(memento.getBoolean(KEY_SHOW_LEGEND), this.settings.isLegendVisible()));
            this.settings.setLegendPosition(HistoricalDataView.safeCast(memento.getInteger(KEY_LEGEND_POSITION), this.settings.getLegendPosition()));
            this.settings.setLogScale(HistoricalDataView.safeCast(memento.getBoolean(KEY_LOG_SCALE), this.settings.isLogScale()));
            this.settings.setTitle(memento.getString(KEY_TITLE));
        }
    }

    private static int safeCast(Integer i, int defval) {
        return i != null ? i : defval;
    }

    private static boolean safeCast(Boolean b, boolean defval) {
        return b != null ? b : defval;
    }

    public void saveState(IMemento memento) {
        memento.putBoolean(KEY_AUTO_REFRESH, this.settings.isAutoRefresh());
        memento.putInteger(KEY_REFRESH_INTERVAL, this.settings.getAutoRefreshInterval());
        memento.putBoolean(KEY_SHOW_LEGEND, this.settings.isLegendVisible());
        memento.putInteger(KEY_LEGEND_POSITION, this.settings.getLegendPosition());
        memento.putBoolean(KEY_LOG_SCALE, this.settings.isLogScale());
        memento.putString(KEY_TITLE, this.settings.getTitle());
    }

    public void initPredefinedGraph(GraphSettings gs) {
        this.settings = gs;
        this.settings.addChangeListener((GraphSettingsChangeListener)this);
        this.configureGraphFromSettings();
    }

    private void configureGraphFromSettings() {
        this.setPartName(this.settings.getTitle());
        this.chart.setChartTitle(this.settings.getTitle());
        this.chart.setItemStyles(Arrays.asList(this.settings.getItemStyles()));
        this.chart.setLogScaleEnabled(this.settings.isLogScale());
        this.setGridVisible(this.settings.isGridVisible());
        this.chart.setLegendVisible(this.settings.isLegendVisible());
        this.chart.setBackground(ColorConverter.colorFromInt((int)this.settings.getBackgroundColor()));
        this.chart.setBackgroundInPlotArea(ColorConverter.colorFromInt((int)this.settings.getPlotBackgroundColor()));
        this.chart.getLegend().setForeground(ColorConverter.colorFromInt((int)this.settings.getLegendTextColor()));
        this.chart.getLegend().setBackground(ColorConverter.colorFromInt((int)this.settings.getLegendBackgroundColor()));
        this.chart.getAxisSet().getXAxis(0).getTick().setForeground(ColorConverter.colorFromInt((int)this.settings.getAxisColor()));
        this.chart.getAxisSet().getYAxis(0).getTick().setForeground(ColorConverter.colorFromInt((int)this.settings.getAxisColor()));
        this.chart.getAxisSet().getXAxis(0).getGrid().setForeground(ColorConverter.colorFromInt((int)this.settings.getGridColor()));
        this.chart.getAxisSet().getYAxis(0).getGrid().setForeground(ColorConverter.colorFromInt((int)this.settings.getGridColor()));
        this.items.clear();
        this.items.addAll(Arrays.asList(this.settings.getItems()));
        for (GraphItem item : this.items) {
            this.chart.addParameter(item);
        }
        if (this.settings.getTimeFrameType() == 1) {
            this.settings.setTimeFrom(new Date(System.currentTimeMillis() - this.settings.getTimeRangeMillis()));
            this.settings.setTimeTo(new Date(System.currentTimeMillis()));
        }
        this.getDataFromServer();
        this.actionAutoRefresh.setChecked(this.settings.isAutoRefresh());
        this.getSite().getShell().getDisplay().timerExec(this.settings.isAutoRefresh() ? this.settings.getAutoRefreshInterval() : -1, this.refreshTimer);
    }

    public void createPartControl(Composite parent) {
        this.chart = new LineChart(parent, 0);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.configureGraphFromSettings();
        this.settings.addChangeListener((GraphSettingsChangeListener)this);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                HistoricalDataView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.chart);
        this.chart.setMenu(menu);
        Control[] controlArray = this.chart.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ch = controlArray[n2];
            ch.setMenu(menu);
            ++n2;
        }
    }

    private void getDataFromServer() {
        ConsoleJob job = new ConsoleJob("Get DCI values for history graph", (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", "org.netxms.ui.eclipse.perfview"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                monitor.beginTask(this.getName(), HistoricalDataView.this.items.size());
                final DciData[] data = new DciData[HistoricalDataView.this.items.size()];
                Threshold[][] thresholds = new Threshold[HistoricalDataView.this.items.size()][];
                int i = 0;
                while (i < HistoricalDataView.this.items.size()) {
                    GraphItem item = (GraphItem)HistoricalDataView.this.items.get(i);
                    data[i] = HistoricalDataView.this.session.getCollectedData(item.getNodeId(), item.getDciId(), HistoricalDataView.this.settings.getTimeFrom(), HistoricalDataView.this.settings.getTimeTo(), 0);
                    thresholds[i] = HistoricalDataView.this.session.getThresholds(item.getNodeId(), item.getDciId());
                    monitor.worked(1);
                    ++i;
                }
                new UIJob("Update chart"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!HistoricalDataView.this.chart.isDisposed()) {
                            HistoricalDataView.this.chart.setTimeRange(HistoricalDataView.this.settings.getTimeFrom(), HistoricalDataView.this.settings.getTimeTo());
                            HistoricalDataView.this.setChartData(data);
                        }
                        HistoricalDataView.this.updateInProgress = false;
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            protected String getErrorMessage() {
                return "Cannot get DCI values for history graph";
            }

            protected void jobFailureHandler() {
                HistoricalDataView.this.updateInProgress = false;
                super.jobFailureHandler();
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setFocus() {
        this.chart.setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                HistoricalDataView.this.updateChart();
            }
        };
        this.actionAutoRefresh = new Action(){

            public void run() {
                HistoricalDataView.this.settings.setAutoRefresh(!HistoricalDataView.this.settings.isAutoRefresh());
                this.setChecked(HistoricalDataView.this.settings.isAutoRefresh());
                HistoricalDataView.this.getSite().getShell().getDisplay().timerExec(HistoricalDataView.this.settings.isAutoRefresh() ? HistoricalDataView.this.settings.getAutoRefreshInterval() : -1, HistoricalDataView.this.refreshTimer);
            }
        };
        this.actionAutoRefresh.setText("Refresh &automatically");
        this.actionAutoRefresh.setChecked(this.settings.isAutoRefresh());
        this.actionLogScale = new Action(){

            public void run() {
                try {
                    HistoricalDataView.this.chart.setLogScaleEnabled(!HistoricalDataView.this.settings.isLogScale());
                    HistoricalDataView.this.settings.setLogScale(!HistoricalDataView.this.settings.isLogScale());
                    HistoricalDataView.this.chart.redraw();
                }
                catch (IllegalStateException e) {
                    MessageDialog.openError((Shell)HistoricalDataView.this.getSite().getShell(), (String)"Error", (String)("Cannot switch to logarithmic scale: " + e.getLocalizedMessage()));
                }
                this.setChecked(HistoricalDataView.this.settings.isLogScale());
            }
        };
        this.actionLogScale.setText("&Logarithmic scale");
        this.actionLogScale.setChecked(this.settings.isLogScale());
        this.actionZoomIn = new Action(){

            public void run() {
                HistoricalDataView.this.chart.getAxisSet().zoomIn();
                HistoricalDataView.this.chart.redraw();
            }
        };
        this.actionZoomIn.setText("Zoom &in");
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        this.actionZoomOut = new Action(){

            public void run() {
                HistoricalDataView.this.chart.getAxisSet().zoomOut();
                HistoricalDataView.this.chart.redraw();
            }
        };
        this.actionZoomOut.setText("Zoom &out");
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
        this.actionAdjustX = new Action(){

            public void run() {
                IAxis[] iAxisArray = HistoricalDataView.this.chart.getAxisSet().getXAxes();
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.adjustRange();
                    ++n2;
                }
                HistoricalDataView.this.chart.redraw();
            }
        };
        this.actionAdjustX.setText("Adjust &X axis");
        this.actionAdjustX.setImageDescriptor(Activator.getImageDescriptor("icons/adjust_x.png"));
        this.actionAdjustY = new Action(){

            public void run() {
                HistoricalDataView.this.chart.adjustYAxis();
                HistoricalDataView.this.chart.redraw();
            }
        };
        this.actionAdjustY.setText("Adjust &Y axis");
        this.actionAdjustY.setImageDescriptor(Activator.getImageDescriptor("icons/adjust_y.png"));
        this.actionAdjustBoth = new Action(){

            public void run() {
                IAxis[] iAxisArray = HistoricalDataView.this.chart.getAxisSet().getXAxes();
                int n = iAxisArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAxis axis = iAxisArray[n2];
                    axis.adjustRange();
                    ++n2;
                }
                HistoricalDataView.this.chart.adjustYAxis();
                HistoricalDataView.this.chart.redraw();
            }
        };
        this.actionAdjustBoth.setText("&Adjust");
        this.actionAdjustBoth.setImageDescriptor(Activator.getImageDescriptor("icons/adjust.png"));
        this.actionShowLegend = new Action("&Show legend"){

            public void run() {
                HistoricalDataView.this.settings.setLegendVisible(!HistoricalDataView.this.settings.isLegendVisible());
                this.setChecked(HistoricalDataView.this.settings.isLegendVisible());
                HistoricalDataView.this.chart.setLegendVisible(HistoricalDataView.this.settings.isLegendVisible());
            }
        };
        this.actionShowLegend.setChecked(this.settings.isLegendVisible());
        this.actionLegendLeft = new Action("Place on &left", 8){

            public void run() {
                HistoricalDataView.this.settings.setLegendPosition(1);
                HistoricalDataView.this.chart.setLegendPosition(HistoricalDataView.this.settings.getLegendPosition());
            }
        };
        this.actionLegendLeft.setChecked(this.settings.getLegendPosition() == 1);
        this.actionLegendRight = new Action("Place on &right", 8){

            public void run() {
                HistoricalDataView.this.settings.setLegendPosition(2);
                HistoricalDataView.this.chart.setLegendPosition(HistoricalDataView.this.settings.getLegendPosition());
            }
        };
        this.actionLegendRight.setChecked(this.settings.getLegendPosition() == 2);
        this.actionLegendTop = new Action("Place on &top", 8){

            public void run() {
                HistoricalDataView.this.settings.setLegendPosition(4);
                HistoricalDataView.this.chart.setLegendPosition(HistoricalDataView.this.settings.getLegendPosition());
            }
        };
        this.actionLegendTop.setChecked(this.settings.getLegendPosition() == 4);
        this.actionLegendBottom = new Action("Place on &bottom", 8){

            public void run() {
                HistoricalDataView.this.settings.setLegendPosition(8);
                HistoricalDataView.this.chart.setLegendPosition(HistoricalDataView.this.settings.getLegendPosition());
            }
        };
        this.actionLegendBottom.setChecked(this.settings.getLegendPosition() == 8);
        this.presetActions = new Action[presetRanges.length];
        int i = 0;
        while (i < presetRanges.length) {
            final Integer presetIndex = i;
            this.presetActions[i] = new Action(){

                public void run() {
                    HistoricalDataView.this.settings.setTimeUnit(presetUnits[presetIndex]);
                    HistoricalDataView.this.settings.setTimeFrame(presetRanges[presetIndex]);
                    HistoricalDataView.this.updateChart();
                }
            };
            this.presetActions[i].setText("Last " + presetNames[i]);
            ++i;
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        MenuManager presets = new MenuManager("&Presets");
        int i = 0;
        while (i < this.presetActions.length) {
            presets.add((IAction)this.presetActions[i]);
            ++i;
        }
        MenuManager legend = new MenuManager("&Legend");
        legend.add((IAction)this.actionShowLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionLogScale);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager presets = new MenuManager("&Presets");
        int i = 0;
        while (i < this.presetActions.length) {
            presets.add((IAction)this.presetActions[i]);
            ++i;
        }
        MenuManager legend = new MenuManager("&Legend");
        legend.add((IAction)this.actionShowLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionLogScale);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void setChartData(DciData[] data) {
        int i = 0;
        while (i < data.length) {
            this.chart.updateParameter(i, data[i], false);
            ++i;
        }
        this.chart.refresh();
    }

    private void updateChart() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        this.settings.setTimeFrom(new Date(System.currentTimeMillis() - this.settings.getTimeRangeMillis()));
        this.settings.setTimeTo(new Date(System.currentTimeMillis()));
        this.getDataFromServer();
    }

    protected void setGridVisible(boolean visible) {
        LineStyle ls = visible ? LineStyle.DOT : LineStyle.NONE;
        this.chart.getAxisSet().getXAxis(0).getGrid().setStyle(ls);
        this.chart.getAxisSet().getYAxis(0).getGrid().setStyle(ls);
    }

    public void dispose() {
        this.getSite().getShell().getDisplay().timerExec(-1, this.refreshTimer);
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.settings);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void onGraphSettingsChange(GraphSettings settings) {
        if (this.settings == settings) {
            this.configureGraphFromSettings();
        }
    }
}

