/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.actions;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.ReportGroup;
import org.netxms.client.objects.ReportRoot;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.reporter.dialogs.CreateReportDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class CreateReport
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private IWorkbenchPart part;
    private long parentId = -1L;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        final CreateReportDialog dlg = new CreateReportDialog(this.window.getShell());
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Create report object", this.part, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                NXCObjectCreationData cd = new NXCObjectCreationData(26, dlg.getObjectName(), CreateReport.this.parentId);
                long reportId = session.createObject(cd);
                File definitionFile = dlg.getDefinitionFile();
                if (definitionFile != null) {
                    session.setReportDefinition(reportId, definitionFile);
                }
            }

            protected String getErrorMessage() {
                return "Cannot create report object \"" + dlg.getObjectName() + "\"";
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        this.parentId = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? ((object = ((IStructuredSelection)selection).getFirstElement()) instanceof ReportGroup || object instanceof ReportRoot ? ((GenericObject)object).getObjectId() : -1L) : -1L;
        action.setEnabled(this.parentId != -1L);
    }
}

