/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.dialogs;

import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.api.client.Session;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.User;
import org.netxms.api.client.users.UserManager;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.UserComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SelectUserDialog
extends Dialog {
    private TableViewer userList;
    private Session session;
    private boolean showGroups;
    private AbstractUserObject[] selection;

    public SelectUserDialog(Shell parentShell, boolean showGroups) {
        super(parentShell);
        this.showGroups = showGroups;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Select users");
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        new Label(dialogArea, 0).setText("Available users");
        String[] columnNames = new String[]{"Login Name"};
        int[] columnWidths = new int[]{250};
        this.userList = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.userList.setComparator((ViewerComparator)new UserComparator());
        this.userList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectUserDialog.this.okPressed();
            }
        });
        this.userList.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return SelectUserDialog.this.showGroups || element instanceof User;
            }
        });
        this.userList.setInput((Object)((UserManager)this.session).getUserDatabaseObjects());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        this.userList.getControl().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.userList.getSelection();
        if (sel.size() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"You must select at least one user from list and then press OK.");
            return;
        }
        this.selection = new AbstractUserObject[sel.size()];
        Iterator it = sel.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.selection[i] = (AbstractUserObject)it.next();
            ++i;
        }
        super.okPressed();
    }

    public AbstractUserObject[] getSelection() {
        return this.selection;
    }
}

