/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.actionmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.ServerAction;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditActionDlg
extends Dialog {
    private ServerAction action;
    private boolean createNew;
    private Text name;
    private LabeledText recipient;
    private LabeledText subject;
    private LabeledText data;
    private Button typeLocalExec;
    private Button typeRemoteExec;
    private Button typeEMail;
    private Button typeSMS;
    private Button typeForward;
    private Button markDisabled;

    public EditActionDlg(Shell parentShell, ServerAction action, boolean createNew) {
        super(parentShell);
        this.action = action;
        this.createNew = createNew;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.createNew ? "Create action" : "Edit action");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        this.name = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)"Name", (String)this.action.getName(), (Object)"WidgetHelper::default_layout_data");
        Group typeGroup = new Group(dialogArea, 0);
        typeGroup.setText("Type");
        typeGroup.setLayout((Layout)new RowLayout(512));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        typeGroup.setLayoutData((Object)gd);
        this.typeLocalExec = new Button((Composite)typeGroup, 16);
        this.typeLocalExec.setText("Execute command on management server");
        this.typeLocalExec.setSelection(this.action.getType() == 0);
        this.typeLocalExec.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeRemoteExec = new Button((Composite)typeGroup, 16);
        this.typeRemoteExec.setText("Execute command on remote node via agent");
        this.typeRemoteExec.setSelection(this.action.getType() == 1);
        this.typeRemoteExec.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeEMail = new Button((Composite)typeGroup, 16);
        this.typeEMail.setText("Send E-Mail");
        this.typeEMail.setSelection(this.action.getType() == 2);
        this.typeEMail.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeSMS = new Button((Composite)typeGroup, 16);
        this.typeSMS.setText("Send SMS to mobile phone");
        this.typeSMS.setSelection(this.action.getType() == 3);
        this.typeSMS.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeForward = new Button((Composite)typeGroup, 16);
        this.typeForward.setText("Forward event to other NetXMS server");
        this.typeForward.setSelection(this.action.getType() == 4);
        this.typeForward.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText("Options");
        optionsGroup.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        this.markDisabled = new Button((Composite)optionsGroup, 32);
        this.markDisabled.setText("Action is &disabled");
        this.markDisabled.setSelection(this.action.isDisabled());
        this.recipient = new LabeledText(dialogArea, 0);
        this.recipient.setLabel(this.getRcptLabel(this.action.getType()));
        this.recipient.setText(this.action.getRecipientAddress());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.recipient.setLayoutData((Object)gd);
        this.subject = new LabeledText(dialogArea, 0);
        this.subject.setLabel("E-Mail subject");
        this.subject.setText(this.action.getEmailSubject());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.subject.setLayoutData((Object)gd);
        this.data = new LabeledText(dialogArea, 0);
        this.data.setLabel(this.getDataLabel(this.action.getType()));
        this.data.setText(this.action.getData());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.data.setLayoutData((Object)gd);
        this.onTypeChange();
        return dialogArea;
    }

    private String getRcptLabel(int type) {
        switch (type) {
            case 1: {
                return "Remote host";
            }
            case 3: {
                return "Phone number";
            }
            case 4: {
                return "Remote NetXMS server";
            }
        }
        return "Recipient's address";
    }

    private String getDataLabel(int type) {
        switch (type) {
            case 0: {
                return "Command";
            }
            case 1: {
                return "Agent's action";
            }
        }
        return "Message text";
    }

    protected void okPressed() {
        if (this.typeLocalExec.getSelection()) {
            this.action.setType(0);
        } else if (this.typeRemoteExec.getSelection()) {
            this.action.setType(1);
        } else if (this.typeEMail.getSelection()) {
            this.action.setType(2);
        } else if (this.typeSMS.getSelection()) {
            this.action.setType(3);
        } else if (this.typeForward.getSelection()) {
            this.action.setType(4);
        }
        this.action.setName(this.name.getText());
        this.action.setRecipientAddress(this.recipient.getText());
        this.action.setEmailSubject(this.subject.getText());
        this.action.setData(this.data.getText());
        this.action.setDisabled(this.markDisabled.getSelection());
        super.okPressed();
    }

    private void onTypeChange() {
        int type = -1;
        if (this.typeLocalExec.getSelection()) {
            type = 0;
        } else if (this.typeRemoteExec.getSelection()) {
            type = 1;
        } else if (this.typeEMail.getSelection()) {
            type = 2;
        } else if (this.typeSMS.getSelection()) {
            type = 3;
        } else if (this.typeForward.getSelection()) {
            type = 4;
        }
        switch (type) {
            case 0: {
                this.recipient.setEnabled(false);
                this.subject.setEnabled(false);
                this.data.setEnabled(true);
                break;
            }
            case 1: {
                this.recipient.setEnabled(true);
                this.subject.setEnabled(false);
                this.data.setEnabled(true);
                break;
            }
            case 2: {
                this.recipient.setEnabled(true);
                this.subject.setEnabled(true);
                this.data.setEnabled(true);
                break;
            }
            case 3: {
                this.recipient.setEnabled(true);
                this.subject.setEnabled(false);
                this.data.setEnabled(true);
                break;
            }
            case 4: {
                this.recipient.setEnabled(true);
                this.subject.setEnabled(false);
                this.data.setEnabled(false);
            }
        }
        this.recipient.setLabel(this.getRcptLabel(type));
        this.data.setLabel(this.getDataLabel(type));
    }

    class TypeButtonSelectionListener
    implements SelectionListener {
        TypeButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            EditActionDlg.this.onTypeChange();
        }
    }
}

