/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverjobmanager.views;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCException;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCServerJob;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverjobmanager.Activator;
import org.netxms.ui.eclipse.serverjobmanager.views.helpers.ServerJobComparator;
import org.netxms.ui.eclipse.serverjobmanager.views.helpers.ServerJobLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ServerJobManager
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverjobmanager.view.server_job_manager";
    public static final String JOB_FAMILY = "ServerJobManagerJob";
    public static final int COLUMN_STATUS = 0;
    public static final int COLUMN_USER = 1;
    public static final int COLUMN_NODE = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    public static final int COLUMN_PROGRESS = 4;
    public static final int COLUMN_MESSAGE = 5;
    private static final String TABLE_CONFIG_PREFIX = "ServerJobManager";
    private static final int CANCEL_JOB = 0;
    private static final int HOLD_JOB = 1;
    private static final int UNHOLD_JOB = 2;
    private SortableTableViewer viewer;
    private NXCSession session = null;
    private NXCListener clientListener = null;
    private RefreshAction actionRefresh;
    private Action actionRestartJob;
    private Action actionCancelJob;
    private Action actionHoldJob;
    private Action actionUnholdJob;

    public void createPartControl(Composite parent) {
        String[] names = new String[]{"Status", "Initiator", "Node", "Description", "Progress", "Message"};
        int[] widths = new int[]{80, 100, 150, 250, 100, 300};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerJobLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerJobComparator());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ServerJobManager.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)ServerJobManager.TABLE_CONFIG_PREFIX);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    ServerJobManager.this.actionCancelJob.setEnabled(selection.size() > 0);
                    ServerJobManager.this.actionHoldJob.setEnabled(selection.size() > 0);
                    ServerJobManager.this.actionUnholdJob.setEnabled(selection.size() > 0);
                }
            }
        });
        this.clientListener = new NXCListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() != 10) {
                    return;
                }
                ServerJobManager.this.refreshJobList(false);
            }
        };
        this.session.addListener((SessionListener)this.clientListener);
        this.refreshJobList(false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRestartJob);
        manager.add((IAction)this.actionCancelJob);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHoldJob);
        manager.add((IAction)this.actionUnholdJob);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCancelJob);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ServerJobManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestartJob);
        manager.add((IAction)this.actionCancelJob);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHoldJob);
        manager.add((IAction)this.actionUnholdJob);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ServerJobManager.this.refreshJobList(true);
            }
        };
        this.actionCancelJob = new Action("&Cancel"){

            public void run() {
                ServerJobManager.this.cancelServerJob();
            }
        };
        this.actionCancelJob.setImageDescriptor(Activator.getImageDescriptor("icons/cancel.png"));
        this.actionCancelJob.setEnabled(false);
        this.actionHoldJob = new Action("&Hold"){

            public void run() {
                ServerJobManager.this.holdServerJob();
            }
        };
        this.actionHoldJob.setImageDescriptor(Activator.getImageDescriptor("icons/hold.gif"));
        this.actionHoldJob.setEnabled(false);
        this.actionUnholdJob = new Action("&Unhold"){

            public void run() {
                ServerJobManager.this.unholdServerJob();
            }
        };
        this.actionUnholdJob.setImageDescriptor(Activator.getImageDescriptor("icons/unhold.gif"));
        this.actionUnholdJob.setEnabled(false);
        this.actionRestartJob = new Action("&Restart"){

            public void run() {
            }
        };
        this.actionRestartJob.setEnabled(false);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.session != null && this.clientListener != null) {
            this.session.removeListener((SessionListener)this.clientListener);
        }
        super.dispose();
    }

    private void refreshJobList(boolean userInitiated) {
        ConsoleJob job = new ConsoleJob("Refresh server job list", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverjobmanager", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final NXCServerJob[] jobList = ServerJobManager.this.session.getServerJobList();
                new UIJob("Update job list"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IStructuredSelection selection = (IStructuredSelection)ServerJobManager.this.viewer.getSelection();
                        Object[] selectedObjects = selection.toArray();
                        ServerJobManager.this.viewer.setInput((Object)jobList);
                        ArrayList<NXCServerJob> selectedJobs = new ArrayList<NXCServerJob>(selectedObjects.length);
                        int i = 0;
                        while (i < selectedObjects.length) {
                            int j = 0;
                            while (j < jobList.length) {
                                if (((NXCServerJob)selectedObjects[i]).getId() == jobList[j].getId()) {
                                    selectedJobs.add(jobList[j]);
                                    break;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        ServerJobManager.this.viewer.setSelection((ISelection)new StructuredSelection(selectedJobs));
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            protected String getErrorMessage() {
                return "Cannot get job list from server";
            }
        };
        job.setUser(userInitiated);
        job.start();
    }

    private void cancelServerJob() {
        this.doJobAction("Cancel", 0);
    }

    private void holdServerJob() {
        this.doJobAction("Hold", 1);
    }

    private void unholdServerJob() {
        this.doJobAction("Unhold", 2);
    }

    private void doJobAction(final String actionName, final int actionId) {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        new ConsoleJob(String.valueOf(actionName) + " server jobs", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverjobmanager", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                block5: for (Object object : selection) {
                    if (object instanceof NXCServerJob) {
                        NXCServerJob jobObject = (NXCServerJob)object;
                        switch (actionId) {
                            case 0: {
                                ServerJobManager.this.session.cancelServerJob(jobObject.getId());
                                continue block5;
                            }
                            case 1: {
                                ServerJobManager.this.session.holdServerJob(jobObject.getId());
                                continue block5;
                            }
                            case 2: {
                                ServerJobManager.this.session.unholdServerJob(jobObject.getId());
                                continue block5;
                            }
                            default: {
                                throw new NXCException(46);
                            }
                        }
                    }
                    throw new NXCException(46);
                }
            }

            protected String getErrorMessage() {
                return "Cannot " + actionName.toLowerCase() + " server job";
            }

            protected void jobFinalize() {
                ServerJobManager.this.refreshJobList(false);
            }
        }.start();
    }
}

