/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.Port;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.widgets.SlotView;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortInfo;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortSelectionListener;
import org.netxms.ui.eclipse.widgets.DashboardComposite;

public class DeviceView
extends DashboardComposite {
    private long nodeId;
    private NXCSession session;
    private Map<Long, PortInfo> ports = new HashMap<Long, PortInfo>();
    private Map<Integer, SlotView> slots = new HashMap<Integer, SlotView>();
    private boolean portStatusVisible = true;
    private Set<PortSelectionListener> selectionListeners = new HashSet<PortSelectionListener>();
    private PortSelectionListener listener;

    public DeviceView(Composite parent, int style) {
        super(parent, style);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.fill = true;
        layout.wrap = false;
        this.setLayout((Layout)layout);
        this.setBackground(new Color((Device)this.getDisplay(), 255, 255, 255));
        this.listener = new PortSelectionListener(){

            @Override
            public void portSelected(PortInfo port) {
                for (PortSelectionListener l : DeviceView.this.selectionListeners) {
                    l.portSelected(port);
                }
            }
        };
    }

    public void refresh() {
        GenericObject object = this.session.findObjectById(this.nodeId);
        if (object == null || !(object instanceof Node)) {
            return;
        }
        for (SlotView s : this.slots.values()) {
            s.setMenu(null);
            s.dispose();
        }
        this.slots.clear();
        this.ports.clear();
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        for (GenericObject o : object.getAllChilds(3)) {
            if ((((Interface)o).getFlags() & 2) == 0) continue;
            interfaces.add((Interface)o);
        }
        Collections.sort(interfaces, new Comparator<Interface>(){

            @Override
            public int compare(Interface arg0, Interface arg1) {
                if (arg0.getSlot() == arg1.getSlot()) {
                    return arg0.getPort() - arg1.getPort();
                }
                return arg0.getSlot() - arg1.getSlot();
            }
        });
        for (Interface iface : interfaces) {
            int slot = iface.getSlot();
            SlotView sv = this.slots.get(slot);
            if (sv == null) {
                sv = new SlotView((Composite)this, 0, "Slot " + Integer.toString(slot));
                sv.setPortStatusVisible(this.portStatusVisible);
                this.slots.put(slot, sv);
            }
            PortInfo p = new PortInfo(iface);
            this.ports.put(iface.getObjectId(), p);
            sv.addPort(p);
        }
        this.layout();
        for (SlotView sv : this.slots.values()) {
            sv.setMenu(this.getMenu());
            sv.addSelectionListener(this.listener);
        }
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
        this.refresh();
    }

    public boolean isPortStatusVisible() {
        return this.portStatusVisible;
    }

    public void setPortStatusVisible(boolean portStatusVisible) {
        this.portStatusVisible = portStatusVisible;
    }

    public void setHighlight(Port[] ports) {
        this.clearHighlight(false);
        Port[] portArray = ports;
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            Port p = portArray[n2];
            SlotView sv = this.slots.get(p.getSlot());
            if (sv != null) {
                sv.addHighlight(p);
            }
            ++n2;
        }
        for (SlotView sv : this.slots.values()) {
            sv.redraw();
        }
    }

    public void clearHighlight(boolean doRedraw) {
        for (SlotView sv : this.slots.values()) {
            sv.clearHighlight();
            if (!doRedraw) continue;
            sv.redraw();
        }
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        for (SlotView sv : this.slots.values()) {
            sv.setMenu(this.getMenu());
        }
    }

    public void addSelectionListener(PortSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(PortSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }
}

