/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.policymanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCException;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class Policy
extends PropertyPage {
    private Text textDescription;
    private String initialDescription;
    private AgentPolicy object;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AgentPolicy)this.getElement().getAdapter(AgentPolicy.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.initialDescription = new String(this.object.getDescription());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.textDescription = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2818, (int)-1, (String)"Description", (String)this.initialDescription, (Object)gd);
        this.textDescription.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (this.textDescription.getText().equals(this.initialDescription)) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final String newDescription = new String(this.textDescription.getText());
        new Job("Change policy"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status;
                try {
                    if (Policy.this.object != null) {
                        NXCObjectModificationData md = new NXCObjectModificationData(Policy.this.object.getObjectId());
                        md.setDescription(newDescription);
                        ((NXCSession)ConsoleSharedData.getSession()).modifyObject(md);
                    }
                    Policy.this.initialDescription = newDescription;
                    status = Status.OK_STATUS;
                }
                catch (Exception e) {
                    status = new Status(4, "org.netxms.ui.eclipse.policymanager", e instanceof NXCException ? ((NXCException)e).getErrorCode() : 0, "Cannot change agent policy: " + e.getMessage(), (Throwable)e);
                }
                if (isApply) {
                    new UIJob("Update \"Policy\" property page"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            Policy.this.setValid(true);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return status;
            }
        }.schedule();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

