/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.Collection;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.Threshold;

public class DataCollectionItem {
    public static final int INTERNAL = 0;
    public static final int AGENT = 1;
    public static final int SNMP = 2;
    public static final int CHECKPOINT_SNMP = 3;
    public static final int PUSH = 4;
    public static final int ACTIVE = 0;
    public static final int DISABLED = 1;
    public static final int NOT_SUPPORTED = 2;
    public static final int DT_INT = 0;
    public static final int DT_UINT = 1;
    public static final int DT_INT64 = 2;
    public static final int DT_UINT64 = 3;
    public static final int DT_STRING = 4;
    public static final int DT_FLOAT = 5;
    public static final int DT_NULL = 6;
    public static final int DELTA_NONE = 0;
    public static final int DELTA_SIMPLE = 1;
    public static final int DELTA_AVERAGE_PER_SECOND = 2;
    public static final int DELTA_AVERAGE_PER_MINUTE = 3;
    public static final int SNMP_RAWTYPE_NONE = 0;
    public static final int SNMP_RAWTYPE_INT32 = 1;
    public static final int SNMP_RAWTYPE_UINT32 = 2;
    public static final int SNMP_RAWTYPE_INT64 = 3;
    public static final int SNMP_RAWTYPE_UINT64 = 4;
    public static final int SNMP_RAWTYPE_DOUBLE = 5;
    public static final int SNMP_RAWTYPE_IP_ADDR = 6;
    public static final int SNMP_RAWTYPE_MAC_ADDR = 7;
    public static final int DCF_ADVANCED_SCHEDULE = 1;
    public static final int DCF_ALL_THRESHOLDS = 2;
    public static final int DCF_RAW_VALUE_OCTET_STRING = 4;
    private DataCollectionConfiguration owner;
    private long id;
    private long templateId;
    private long resourceId;
    private long proxyNode;
    private int dataType;
    private int pollingInterval;
    private int retentionTime;
    private int origin;
    private int status;
    private int deltaCalculation;
    private int flags;
    private String name;
    private String description;
    private String transformationScript;
    private String instance;
    private String systemTag;
    private String perfTabSettings;
    private int baseUnits;
    private int multiplier;
    private String customUnitName;
    private int snmpRawValueType;
    private int snmpPort;
    private ArrayList<String> schedules;
    private ArrayList<Threshold> thresholds;

    protected DataCollectionItem(DataCollectionConfiguration owner, NXCPMessage msg) {
        this.owner = owner;
        this.id = msg.getVariableAsInt64(43L);
        this.templateId = msg.getVariableAsInt64(153L);
        this.resourceId = msg.getVariableAsInt64(266L);
        this.proxyNode = msg.getVariableAsInt64(195L);
        this.dataType = msg.getVariableAsInteger(47L);
        this.pollingInterval = msg.getVariableAsInteger(44L);
        this.retentionTime = msg.getVariableAsInteger(45L);
        this.origin = msg.getVariableAsInteger(46L);
        this.status = msg.getVariableAsInteger(48L);
        this.deltaCalculation = msg.getVariableAsInteger(105L);
        this.flags = msg.getVariableAsInteger(13L);
        this.transformationScript = msg.getVariableAsString(106L);
        this.name = msg.getVariableAsString(20L);
        this.description = msg.getVariableAsString(27L);
        this.instance = msg.getVariableAsString(116L);
        this.systemTag = msg.getVariableAsString(346L);
        this.baseUnits = msg.getVariableAsInteger(322L);
        this.multiplier = msg.getVariableAsInteger(323L);
        this.customUnitName = msg.getVariableAsString(324L);
        this.perfTabSettings = msg.getVariableAsString(325L);
        this.snmpRawValueType = msg.getVariableAsInteger(249L);
        this.snmpPort = msg.getVariableAsInteger(80L);
        int count = msg.getVariableAsInteger(182L);
        this.schedules = new ArrayList(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            this.schedules.add(msg.getVariableAsString(varId));
            ++i;
            ++varId;
        }
        count = msg.getVariableAsInteger(54L);
        this.thresholds = new ArrayList(count);
        varId = 0x20000000L;
        i = 0;
        while (i < count) {
            this.thresholds.add(new Threshold(msg, varId));
            ++i;
            varId += 10L;
        }
    }

    protected DataCollectionItem(DataCollectionConfiguration owner, long id) {
        this.owner = owner;
        this.id = id;
        this.templateId = 0L;
        this.resourceId = 0L;
        this.proxyNode = 0L;
        this.dataType = 0;
        this.pollingInterval = 60;
        this.retentionTime = 30;
        this.origin = 1;
        this.status = 0;
        this.deltaCalculation = 0;
        this.flags = 0;
        this.transformationScript = null;
        this.perfTabSettings = null;
        this.name = "";
        this.description = "";
        this.instance = "";
        this.systemTag = "";
        this.baseUnits = 0;
        this.multiplier = 0;
        this.customUnitName = null;
        this.snmpRawValueType = 0;
        this.snmpPort = 0;
        this.schedules = new ArrayList(0);
        this.thresholds = new ArrayList(0);
    }

    public void fillMessage(NXCPMessage msg) {
        int i;
        msg.setVariableInt32(43L, (int)this.id);
        msg.setVariableInt16(47L, this.dataType);
        msg.setVariableInt32(44L, this.pollingInterval);
        msg.setVariableInt32(45L, this.retentionTime);
        msg.setVariableInt16(46L, this.origin);
        msg.setVariableInt16(105L, this.deltaCalculation);
        msg.setVariableInt16(48L, this.status);
        msg.setVariable(20L, this.name);
        msg.setVariable(27L, this.description);
        msg.setVariable(116L, this.instance);
        msg.setVariable(346L, this.systemTag);
        msg.setVariable(106L, this.transformationScript);
        msg.setVariableInt16(13L, this.flags);
        msg.setVariableInt16(249L, this.snmpRawValueType);
        msg.setVariableInt32(266L, (int)this.resourceId);
        msg.setVariableInt32(195L, (int)this.proxyNode);
        msg.setVariableInt16(322L, this.baseUnits);
        msg.setVariableInt32(323L, this.multiplier);
        if (this.customUnitName != null) {
            msg.setVariable(324L, this.customUnitName);
        }
        if (this.perfTabSettings != null) {
            msg.setVariable(325L, this.perfTabSettings);
        }
        msg.setVariableInt16(80L, this.snmpPort);
        msg.setVariableInt32(182L, this.schedules.size());
        long varId = 0x10000000L;
        for (i = 0; i < this.schedules.size(); ++i) {
            msg.setVariable(varId++, this.schedules.get(i));
        }
        msg.setVariableInt32(54L, this.thresholds.size());
        varId = 0x20000000L;
        i = 0;
        while (i < this.thresholds.size()) {
            this.thresholds.get(i).fillMessage(msg, varId);
            ++i;
            varId += 10L;
        }
    }

    public long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(long templateId) {
        this.templateId = templateId;
    }

    public long getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(long resourceId) {
        this.resourceId = resourceId;
    }

    public long getProxyNode() {
        return this.proxyNode;
    }

    public void setProxyNode(long proxyNode) {
        this.proxyNode = proxyNode;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int retentionTime) {
        this.retentionTime = retentionTime;
    }

    public int getOrigin() {
        return this.origin;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getDeltaCalculation() {
        return this.deltaCalculation;
    }

    public void setDeltaCalculation(int deltaCalculation) {
        this.deltaCalculation = deltaCalculation;
    }

    public boolean isProcessAllThresholds() {
        return (this.flags & 2) != 0;
    }

    public void setProcessAllThresholds(boolean processAllThresholds) {
        this.flags = processAllThresholds ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isUseAdvancedSchedule() {
        return (this.flags & 1) != 0;
    }

    public void setUseAdvancedSchedule(boolean useAdvancedSchedule) {
        this.flags = useAdvancedSchedule ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isSnmpRawValueInOctetString() {
        return (this.flags & 4) != 0;
    }

    public void setSnmpRawValueInOctetString(boolean enable) {
        this.flags = enable ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTransformationScript() {
        return this.transformationScript;
    }

    public void setTransformationScript(String transformationScript) {
        this.transformationScript = transformationScript;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public int getBaseUnits() {
        return this.baseUnits;
    }

    public void setBaseUnits(int baseUnits) {
        this.baseUnits = baseUnits;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public String getCustomUnitName() {
        return this.customUnitName;
    }

    public void setCustomUnitName(String customUnitName) {
        this.customUnitName = customUnitName;
    }

    public long getId() {
        return this.id;
    }

    public ArrayList<String> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(Collection<String> newSchedules) {
        this.schedules.clear();
        for (String s : newSchedules) {
            this.schedules.add(new String(s));
        }
    }

    public ArrayList<Threshold> getThresholds() {
        return this.thresholds;
    }

    public DataCollectionConfiguration getOwner() {
        return this.owner;
    }

    public long getNodeId() {
        return this.owner.getNodeId();
    }

    public String getSystemTag() {
        return this.systemTag;
    }

    public void setSystemTag(String systemTag) {
        this.systemTag = systemTag;
    }

    public String getPerfTabSettings() {
        return this.perfTabSettings;
    }

    public void setPerfTabSettings(String perfTabSettings) {
        this.perfTabSettings = perfTabSettings;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(int snmpPort) {
        this.snmpPort = snmpPort;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getSnmpRawValueType() {
        return this.snmpRawValueType;
    }

    public void setSnmpRawValueType(int snmpRawValueType) {
        this.snmpRawValueType = snmpRawValueType;
    }
}

