/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.sql.rowset.serial.SerialBlob;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DateFormatFactory;
import org.eclipse.birt.core.data.DateFormatISO8601;
import org.eclipse.birt.core.data.DateUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.i18n.ResourceHandle;
import org.eclipse.birt.core.script.JavascriptEvalUtil;

public final class DataTypeUtil {
    private static ULocale DEFAULT_LOCALE = ULocale.US;
    private static ULocale JRE_DEFAULT_LOCALE = ULocale.getDefault();
    private static SimpleDateFormat MysqlUSDateFormatter = new SimpleDateFormat("M/d/yyyy HH:mm");
    private static Pattern p1 = Pattern.compile(".*[0-9]+:[0-9]+:[0-9]+.*");
    private static Pattern p2 = Pattern.compile(".*[0-9]+:[0-9]+.*");
    private static Map dfMap = new HashMap();
    private static Map nfMap = new HashMap();
    private static int DEFAULT_DATE_STYLE = 0;
    public static ResourceBundle resourceBundle = new ResourceHandle(JRE_DEFAULT_LOCALE).getUResourceBundle();
    public static long count = 0L;

    public static Object convert(Object source, int toType) throws BirtException {
        source = JavascriptEvalUtil.convertJavascriptValue(source);
        if (toType == -1 || toType == 0) {
            return source;
        }
        switch (toType) {
            case 2: {
                return DataTypeUtil.toInteger(source);
            }
            case 4: {
                return DataTypeUtil.toBigDecimal(source);
            }
            case 1: {
                return DataTypeUtil.toBoolean(source);
            }
            case 6: {
                return DataTypeUtil.toDate(source);
            }
            case 3: {
                return DataTypeUtil.toDouble(source);
            }
            case 5: {
                return DataTypeUtil.toString(source);
            }
            case 7: {
                return DataTypeUtil.toBytes(source);
            }
            case 8: {
                return DataTypeUtil.toBytes(source);
            }
            case 9: {
                return DataTypeUtil.toSqlDate(source);
            }
            case 10: {
                return DataTypeUtil.toSqlTime(source);
            }
            case 11: {
                return source;
            }
        }
        throw new CoreException("INVALID_TYPE", (Object)resourceBundle);
    }

    public static Object convert(Object source, Class toTypeClass) throws BirtException {
        if (source != null && source.getClass() == toTypeClass) {
            return source;
        }
        if (toTypeClass == DataType.getClass(0)) {
            return source;
        }
        if (toTypeClass == Integer.class) {
            return DataTypeUtil.toInteger(source);
        }
        if (toTypeClass == BigDecimal.class) {
            return DataTypeUtil.toBigDecimal(source);
        }
        if (toTypeClass == Boolean.class) {
            return DataTypeUtil.toBoolean(source);
        }
        if (toTypeClass == Time.class) {
            return DataTypeUtil.toSqlTime(source);
        }
        if (toTypeClass == Date.class) {
            return DataTypeUtil.toSqlDate(source);
        }
        if (toTypeClass == Timestamp.class) {
            return DataTypeUtil.toTimestamp(source);
        }
        if (toTypeClass == java.util.Date.class) {
            return DataTypeUtil.toDate(source);
        }
        if (toTypeClass == Double.class) {
            return DataTypeUtil.toDouble(source);
        }
        if (toTypeClass == String.class) {
            return DataTypeUtil.toString(source);
        }
        if (toTypeClass == Blob.class) {
            if (source instanceof byte[]) {
                return source;
            }
            return DataTypeUtil.toBlob(source);
        }
        if (toTypeClass == byte[].class) {
            return source;
        }
        if (toTypeClass == Object.class) {
            return source;
        }
        throw new CoreException("INVALID_TYPE", (Object)resourceBundle);
    }

    public static Integer toInteger(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Integer) {
            return (Integer)source;
        }
        if (source instanceof Number) {
            if (!DataTypeUtil.isConvertableToInteger((Number)source)) {
                throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Integer"});
            }
            int intValue = ((Number)source).intValue();
            return intValue;
        }
        if (source instanceof Boolean) {
            if (((Boolean)source).booleanValue()) {
                return 1;
            }
            return 0;
        }
        if (source instanceof java.util.Date) {
            long longValue = ((java.util.Date)source).getTime();
            if (!DataTypeUtil.isConvertableToInteger(longValue)) {
                throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Integer"});
            }
            return (int)longValue;
        }
        if (source instanceof String) {
            try {
                return Integer.valueOf((String)source);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Number number = NumberFormat.getInstance((ULocale)JRE_DEFAULT_LOCALE).parse((String)source);
                    if (number != null) {
                        if (!DataTypeUtil.isConvertableToInteger(number)) {
                            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Integer"});
                        }
                        return number.intValue();
                    }
                    throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Integer"});
                }
                catch (ParseException parseException) {
                    throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Integer"});
                }
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Integer"});
    }

    public static BigDecimal toBigDecimal(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof BigDecimal) {
            return (BigDecimal)source;
        }
        if (source instanceof Number) {
            String str = ((Number)source).toString();
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoreException("CONVERT_FAILS", new Object[]{str, "BigDecimal"});
            }
        }
        if (source instanceof Boolean) {
            if (((Boolean)source).booleanValue()) {
                return new BigDecimal(1.0);
            }
            return new BigDecimal(0.0);
        }
        if (source instanceof java.util.Date) {
            long longValue = ((java.util.Date)source).getTime();
            return new BigDecimal(longValue);
        }
        if (source instanceof String) {
            try {
                return new BigDecimal((String)source);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Number number = NumberFormat.getInstance((ULocale)JRE_DEFAULT_LOCALE).parse((String)source);
                    if (number != null) {
                        return new BigDecimal(number.toString());
                    }
                    throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "BigDecimal"});
                }
                catch (ParseException parseException) {
                    throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "BigDecimal"});
                }
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "BigDecimal"});
    }

    public static Boolean toBoolean(Object source) throws BirtException {
        if (source == null) {
            return Boolean.FALSE;
        }
        if (source instanceof Boolean) {
            return (Boolean)source;
        }
        if (source instanceof Number) {
            if (((Number)source).doubleValue() == 0.0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (source instanceof String) {
            if (((String)source).equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (((String)source).equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            try {
                if (Double.parseDouble((String)source) == 0.0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Boolean"});
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Boolean"});
    }

    public static java.util.Date toDate(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof java.util.Date) {
            return new java.util.Date(((java.util.Date)source).getTime());
        }
        if (source instanceof String) {
            return DataTypeUtil.toDate((String)source);
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
    }

    public static Timestamp toTimestamp(Object source) throws BirtException {
        java.util.Date date = DataTypeUtil.toDate(source);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static Time toSqlTime(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof java.util.Date) {
            return DataTypeUtil.toSqlTime((java.util.Date)source);
        }
        if (source instanceof String) {
            try {
                return DataTypeUtil.toSqlTime(DataTypeUtil.toDate((String)source));
            }
            catch (Exception exception) {
                try {
                    return DataTypeUtil.toSqlTime((String)source);
                }
                catch (Exception exception2) {}
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Time"});
    }

    private static Time toSqlTime(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int firstColon = s.indexOf(58);
        int secondColon = s.indexOf(58, firstColon + 1);
        int marker = secondColon + 1;
        while (marker < s.length()) {
            if (!DataTypeUtil.isDigitTen(s.charAt(marker))) break;
            ++marker;
        }
        int addHour = 0;
        String markerValue = null;
        String aMarker = null;
        if (marker < s.length()) {
            markerValue = s.substring(marker).trim();
            if ("am".compareToIgnoreCase(markerValue) == 0) {
                addHour = 0;
                aMarker = "am";
            } else if ("pm".compareToIgnoreCase(markerValue) == 0) {
                addHour = 12;
                aMarker = "pm";
            } else {
                throw new IllegalArgumentException();
            }
        }
        if (firstColon <= 0 || secondColon <= 0 || secondColon >= s.length() - 1) {
            throw new IllegalArgumentException();
        }
        int hour = Integer.parseInt(s.substring(0, firstColon));
        int minute = Integer.parseInt(s.substring(firstColon + 1, secondColon));
        if (minute < 0 || minute > 60) {
            throw new IllegalArgumentException();
        }
        int second = marker < s.length() ? Integer.parseInt(s.substring(secondColon + 1, marker)) : Integer.parseInt(s.substring(secondColon + 1));
        if (second < 0 || second > 60) {
            throw new IllegalArgumentException();
        }
        if (hour == 12 && minute == 0 && second == 0 && aMarker != null) {
            hour = "am".equals(aMarker) ? 24 : 12;
        } else {
            if (hour < 0 || hour > 12 && markerValue != null && markerValue.length() > 0) {
                throw new IllegalArgumentException();
            }
            if ((hour += addHour) > 24) {
                throw new IllegalArgumentException();
            }
        }
        return DataTypeUtil.toSqlTime(hour, minute, second);
    }

    private static Time toSqlTime(int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return new Time(calendar.getTimeInMillis());
    }

    private static boolean isDigitTen(char c) {
        return c <= '9' && c >= '0';
    }

    private static Time toSqlTime(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return new Time(calendar.getTimeInMillis());
    }

    public static Date toSqlDate(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return (Date)source;
        }
        if (source instanceof java.util.Date) {
            return DataTypeUtil.toSqlDate((java.util.Date)source);
        }
        if (source instanceof String) {
            try {
                return DataTypeUtil.toSqlDate(DataTypeUtil.toDate((String)source));
            }
            catch (Exception exception) {
                try {
                    return Date.valueOf((String)source);
                }
                catch (Exception exception2) {}
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "java.sql.Date"});
    }

    private static Date toSqlDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static java.util.Date toDate(String source, Locale locale) throws BirtException {
        return DataTypeUtil.toDate(source, ULocale.forLocale((Locale)locale));
    }

    public static java.util.Date toDate(String source, ULocale locale) throws BirtException {
        return DataTypeUtil.toDate(source, locale, null);
    }

    public static java.util.Date toDate(String source, ULocale locale, TimeZone timeZone) throws BirtException {
        if (source == null) {
            return null;
        }
        DateFormat dateFormat = null;
        java.util.Date resultDate = null;
        boolean existTime = p1.matcher(source).matches() || p2.matcher(source).matches();
        int i = DEFAULT_DATE_STYLE;
        while (i <= 3) {
            int j = DEFAULT_DATE_STYLE;
            while (j <= 3) {
                dateFormat = DateFormatFactory.getDateTimeInstance(i, j, locale);
                TimeZone savedTimeZone = null;
                if (timeZone != null) {
                    savedTimeZone = dateFormat.getTimeZone();
                    dateFormat.setTimeZone(timeZone);
                }
                try {
                    java.util.Date date = resultDate = dateFormat.parse(source);
                    return date;
                }
                catch (ParseException parseException) {
                }
                finally {
                    if (savedTimeZone != null) {
                        dateFormat.setTimeZone(savedTimeZone);
                    }
                }
                ++j;
            }
            if (!existTime) {
                dateFormat = DateFormatFactory.getDateInstance(i, locale);
                TimeZone savedTimeZone = null;
                if (timeZone != null) {
                    savedTimeZone = dateFormat.getTimeZone();
                    dateFormat.setTimeZone(timeZone);
                }
                try {
                    java.util.Date date = resultDate = dateFormat.parse(source);
                    return date;
                }
                catch (ParseException parseException) {
                }
                finally {
                    if (savedTimeZone != null) {
                        dateFormat.setTimeZone(savedTimeZone);
                    }
                }
            }
            ++i;
        }
        if (resultDate == null) {
            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
        }
        return resultDate;
    }

    public static java.util.Date toDate(String source, TimeZone timeZone) throws BirtException {
        assert (timeZone != null);
        try {
            return DataTypeUtil.toDateISO8601(source, timeZone);
        }
        catch (BirtException birtException) {
            try {
                return DataTypeUtil.toDate(source, JRE_DEFAULT_LOCALE, timeZone);
            }
            catch (BirtException birtException2) {
                return DataTypeUtil.toDate(source, DEFAULT_LOCALE, timeZone);
            }
        }
    }

    public static java.util.Date toDateWithCheck(String source, Locale locale) throws BirtException {
        return DataTypeUtil.toDateWithCheck(source, ULocale.forLocale((Locale)locale));
    }

    public static java.util.Date toDateWithCheck(String source, ULocale locale) throws BirtException {
        DateFormat dateFormat = DateFormatFactory.getDateInstance(3, locale);
        java.util.Date resultDate = null;
        try {
            resultDate = dateFormat.parse(source);
        }
        catch (ParseException parseException) {
            return DataTypeUtil.toDate(source, locale);
        }
        if (!DateUtil.checkValid(dateFormat, source)) {
            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
        }
        return resultDate;
    }

    public static Double toDouble(Object source, Locale locale) throws CoreException {
        return DataTypeUtil.toDouble(source, ULocale.forLocale((Locale)locale));
    }

    public static Double toDouble(Object source, ULocale locale) throws CoreException {
        if (source == null) {
            return null;
        }
        if (source instanceof Double) {
            return (Double)source;
        }
        if (source instanceof Number) {
            if (!DataTypeUtil.isConvertableToDouble((Number)source)) {
                throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Double"});
            }
            double doubleValue = ((Number)source).doubleValue();
            return new Double(doubleValue);
        }
        if (source instanceof Boolean) {
            if (((Boolean)source).booleanValue()) {
                return new Double(1.0);
            }
            return new Double(0.0);
        }
        if (source instanceof java.util.Date) {
            double doubleValue = ((java.util.Date)source).getTime();
            return new Double(doubleValue);
        }
        if (source instanceof String) {
            try {
                return Double.valueOf((String)source);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Number number = NumberFormat.getInstance((ULocale)(locale == null ? JRE_DEFAULT_LOCALE : locale)).parse((String)source);
                    if (number != null) {
                        if (!DataTypeUtil.isConvertableToDouble(number)) {
                            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Double"});
                        }
                        return new Double(number.doubleValue());
                    }
                    throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Double"});
                }
                catch (ParseException parseException) {
                    throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Double"});
                }
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Double"});
    }

    public static Double toDouble(Object source) throws BirtException {
        return DataTypeUtil.toDouble(source, JRE_DEFAULT_LOCALE);
    }

    public static String toString(Object source) throws BirtException {
        return DataTypeUtil.toString(source, JRE_DEFAULT_LOCALE);
    }

    public static String toString(Object source, Locale locale) throws BirtException {
        return DataTypeUtil.toString(source, ULocale.forLocale((Locale)locale));
    }

    public static String toLocaleNeutralString(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Time) {
            return ((Time)source).toString();
        }
        if (source instanceof Date) {
            return ((Date)source).toString();
        }
        if (source instanceof Timestamp) {
            return ((Timestamp)source).toString();
        }
        if (source instanceof java.util.Date) {
            return DateFormatISO8601.format((java.util.Date)source);
        }
        if (source instanceof Number) {
            return ((Number)source).toString();
        }
        return DataTypeUtil.toLimitedSizeString(source);
    }

    public static String toString(Object source, ULocale locale) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Time) {
            return DataTypeUtil.toString((java.util.Date)source, locale);
        }
        if (source instanceof Date) {
            return ((Date)source).toString();
        }
        if (source instanceof Timestamp) {
            return ((Timestamp)source).toString();
        }
        if (source instanceof java.util.Date) {
            return DataTypeUtil.toString((java.util.Date)source, locale);
        }
        if (source instanceof Number) {
            return DataTypeUtil.toString((Number)source, locale);
        }
        return DataTypeUtil.toLimitedSizeString(source);
    }

    private static String toLimitedSizeString(Object source) {
        if (source instanceof byte[]) {
            StringBuffer buf = new StringBuffer();
            byte[] sourceValue = (byte[])source;
            int length = Math.min(sourceValue.length, 8);
            int i = 0;
            while (i < length) {
                buf.append(Integer.toHexString(sourceValue[i]).toUpperCase());
                buf.append(" ");
                ++i;
            }
            if (sourceValue.length > 8) {
                buf.append("...");
            }
            return buf.toString();
        }
        return source.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(Number source, ULocale locale) {
        NumberFormat nf = (NumberFormat)nfMap.get(locale);
        if (nf == null) {
            Map map = nfMap;
            synchronized (map) {
                nf = (NumberFormat)nfMap.get(locale);
                if (nf == null) {
                    nf = NumberFormat.getInstance((ULocale)locale);
                    nfMap.put(locale, nf);
                }
            }
        }
        return nf.format((Object)source);
    }

    public static Blob toBlob(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Blob) {
            return (Blob)source;
        }
        if (source instanceof byte[]) {
            try {
                return new SerialBlob((byte[])source);
            }
            catch (Exception exception) {
                throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Blob"});
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Blob"});
    }

    public static byte[] toBytes(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        if (source instanceof Blob) {
            try {
                return ((Blob)source).getBytes(1L, (int)((Blob)source).length());
            }
            catch (SQLException sQLException) {
                throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Binary"});
            }
        }
        throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Binary"});
    }

    public static int toApiDataType(Class clazz) {
        if (clazz == null) {
            return -1;
        }
        if (clazz == DataType.AnyType.class) {
            return 0;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return 3;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return 5;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (clazz == Date.class) {
            return 9;
        }
        if (clazz == Time.class) {
            return 10;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return 6;
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (Clob.class.isAssignableFrom(clazz) || clazz.getName().equals("org.eclipse.datatools.connectivity.oda.IClob")) {
            return 5;
        }
        if (Blob.class.isAssignableFrom(clazz) || clazz.getName().equals("org.eclipse.datatools.connectivity.oda.IBlob")) {
            return 7;
        }
        if (clazz == Boolean.class) {
            return 1;
        }
        if (clazz == Object.class) {
            return 11;
        }
        return -1;
    }

    public static int toApiDataType(int odaDataTypeCode) throws BirtException {
        Class odiTypeClass = DataTypeUtil.toOdiTypeClass(odaDataTypeCode);
        return DataTypeUtil.toApiDataType(odiTypeClass);
    }

    public static Object toAutoValue(Object evaValue) {
        if (evaValue == null) {
            return null;
        }
        Object value = null;
        if (evaValue instanceof String) {
            String stringValue = (String)evaValue;
            value = DataTypeUtil.toIntegerValue(evaValue);
            if (value == null) {
                try {
                    value = Double.valueOf(stringValue);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        value = new BigDecimal(stringValue);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        try {
                            value = DataTypeUtil.toDate(stringValue);
                        }
                        catch (BirtException birtException) {
                            value = evaValue;
                        }
                    }
                }
            }
        }
        return value;
    }

    public static Integer toIntegerValue(Object evaValue) {
        Integer value = null;
        if (evaValue instanceof String) {
            String stringValue = evaValue.toString();
            try {
                value = Integer.valueOf(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double ddValue = Double.valueOf(stringValue);
                    int intValue = ddValue.intValue();
                    double doubleValue = ddValue;
                    value = Math.abs((double)intValue - doubleValue) < 1.0E-7 ? Integer.valueOf(String.valueOf(intValue)) : null;
                }
                catch (NumberFormatException numberFormatException2) {
                    value = null;
                }
            }
        }
        return value;
    }

    private static java.util.Date toDate(String source) throws BirtException {
        try {
            return DataTypeUtil.toDateISO8601(source, null);
        }
        catch (BirtException birtException) {
            try {
                return DataTypeUtil.toDate(source, JRE_DEFAULT_LOCALE);
            }
            catch (BirtException birtException2) {
                try {
                    return DataTypeUtil.toDate(source, DEFAULT_LOCALE);
                }
                catch (BirtException birtException3) {
                    return DataTypeUtil.toDateForSpecialFormat(source);
                }
            }
        }
    }

    private static java.util.Date toDateISO8601(String source, TimeZone timeZone) throws BirtException {
        java.util.Date resultDate = null;
        try {
            resultDate = DateFormatISO8601.parse(source, timeZone);
            return resultDate;
        }
        catch (ParseException parseException) {
            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
        }
    }

    private static java.util.Date toDateForSpecialFormat(String source) throws BirtException {
        try {
            return MysqlUSDateFormatter.parse(source);
        }
        catch (ParseException parseException) {
            throw new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Date"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(java.util.Date source, ULocale locale) {
        DateFormatter df = null;
        df = (DateFormatter)dfMap.get(locale);
        if (df == null) {
            Map map = dfMap;
            synchronized (map) {
                df = (DateFormatter)dfMap.get(locale);
                if (df == null) {
                    df = new DateFormatter(locale);
                    dfMap.put(locale, df);
                }
            }
        }
        return df.format(source);
    }

    public static Class toOdiTypeClass(int odaDataTypeCode) throws BirtException {
        if (odaDataTypeCode != 1 && odaDataTypeCode != 4 && odaDataTypeCode != 8 && odaDataTypeCode != 3 && odaDataTypeCode != 91 && odaDataTypeCode != 92 && odaDataTypeCode != 93 && odaDataTypeCode != 2004 && odaDataTypeCode != 2005 && odaDataTypeCode != 16 && odaDataTypeCode != 2000 && odaDataTypeCode != 0) {
            throw new CoreException("INVALID_TYPE");
        }
        Class fieldClass = null;
        switch (odaDataTypeCode) {
            case 1: {
                fieldClass = String.class;
                break;
            }
            case 4: {
                fieldClass = Integer.class;
                break;
            }
            case 8: {
                fieldClass = Double.class;
                break;
            }
            case 3: {
                fieldClass = BigDecimal.class;
                break;
            }
            case 91: {
                fieldClass = Date.class;
                break;
            }
            case 92: {
                fieldClass = Time.class;
                break;
            }
            case 93: {
                fieldClass = Timestamp.class;
                break;
            }
            case 2004: {
                fieldClass = Blob.class;
                break;
            }
            case 2005: {
                fieldClass = Clob.class;
                break;
            }
            case 16: {
                fieldClass = Boolean.class;
                break;
            }
            case 2000: {
                fieldClass = Object.class;
                break;
            }
            case 0: {
                fieldClass = null;
            }
        }
        return fieldClass;
    }

    public static int toOdaDataType(Class odiTypeClass) {
        int odaType = 1;
        if (odiTypeClass == null) {
            odaType = 1;
        } else if (odiTypeClass == String.class) {
            odaType = 1;
        } else if (odiTypeClass == Integer.class) {
            odaType = 4;
        } else if (odiTypeClass == Double.class) {
            odaType = 8;
        } else if (odiTypeClass == BigDecimal.class) {
            odaType = 3;
        } else if (odiTypeClass == Time.class) {
            odaType = 92;
        } else if (odiTypeClass == Timestamp.class) {
            odaType = 93;
        } else if (odiTypeClass == Date.class) {
            odaType = 91;
        } else if (odiTypeClass == java.util.Date.class) {
            odaType = 93;
        } else if (odiTypeClass == Blob.class) {
            odaType = 2004;
        } else if (odiTypeClass == Clob.class) {
            odaType = 2005;
        } else if (odiTypeClass == Boolean.class) {
            odaType = 16;
        } else if (odiTypeClass == Object.class) {
            odaType = 2000;
        }
        return odaType;
    }

    private static boolean isConvertableToInteger(Number n) {
        assert (n != null);
        long longValue = n.longValue();
        return longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE;
    }

    private static boolean isConvertableToDouble(Number n) {
        assert (n != null);
        double doubleValue = n.doubleValue();
        return !Double.isInfinite(doubleValue);
    }
}

