/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DialChartConfig;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class DialChart
extends PropertyPage {
    private DialChartConfig config;
    private LabeledText title;
    private LabeledText maxValue;
    private LabeledText yellowZone;
    private LabeledText redZone;

    protected Control createContents(Composite parent) {
        this.config = (DialChartConfig)this.getElement().getAdapter(DialChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.title = new LabeledText(dialogArea, 0);
        this.title.setLabel("Title");
        this.title.setText(this.config.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.maxValue = new LabeledText(dialogArea, 0);
        this.maxValue.setLabel("Maximum value");
        this.maxValue.setText(Double.toString(this.config.getMaxValue()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.maxValue.setLayoutData((Object)gd);
        this.yellowZone = new LabeledText(dialogArea, 0);
        this.yellowZone.setLabel("Yellow zone start");
        this.yellowZone.setText(Double.toString(this.config.getYellowZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.yellowZone.setLayoutData((Object)gd);
        new Label(dialogArea, 0).setText("");
        this.redZone = new LabeledText(dialogArea, 0);
        this.redZone.setLabel("Red zone start");
        this.redZone.setText(Double.toString(this.config.getRedZone()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.redZone.setLayoutData((Object)gd);
        return dialogArea;
    }

    public boolean performOk() {
        double r;
        double y;
        double m;
        try {
            m = Double.parseDouble(this.maxValue.getText().trim());
            y = Double.parseDouble(this.yellowZone.getText().trim());
            r = Double.parseDouble(this.redZone.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please enter correct number");
            return false;
        }
        this.config.setTitle(this.title.getText());
        this.config.setMaxValue(m);
        this.config.setYellowZone(y);
        this.config.setRedZone(r);
        return true;
    }
}

