/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.GraphItemStyle;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.widgets.LineChart;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardDciInfo;
import org.netxms.ui.eclipse.dashboard.widgets.internal.LineChartConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LineChartElement
extends ElementWidget {
    private LineChart chart;
    private LineChartConfig config;
    private Runnable refreshTimer;
    private boolean updateInProgress = false;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();

    public LineChartElement(DashboardControl parent, DashboardElement element) {
        super(parent, element);
        try {
            this.config = LineChartConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new LineChartConfig();
        }
        this.setLayout((Layout)new FillLayout());
        this.chart = new LineChart((Composite)this, 0);
        this.chart.setZoomEnabled(false);
        this.chart.setTitleVisible(true);
        this.chart.setChartTitle(this.config.getTitle());
        this.chart.setLegendVisible(this.config.isShowLegend());
        ArrayList<GraphItemStyle> styles = new ArrayList<GraphItemStyle>(this.config.getDciList().length);
        int index = 0;
        DashboardDciInfo[] dashboardDciInfoArray = this.config.getDciList();
        int n = dashboardDciInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DashboardDciInfo dci = dashboardDciInfoArray[n2];
            this.chart.addParameter(new GraphItem(dci.nodeId, dci.dciId, 0, 0, Long.toString(dci.dciId), dci.getName()));
            int color = dci.getColorAsInt();
            if (color == -1) {
                color = ChartColor.getDefaultColor((int)index).getRGB();
            }
            styles.add(new GraphItemStyle(0, color, 2, 0));
            ++index;
            ++n2;
        }
        this.chart.setItemStyles(styles);
        final Display display = this.getDisplay();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (LineChartElement.this.isDisposed()) {
                    return;
                }
                LineChartElement.this.refreshData();
                display.timerExec(30000, (Runnable)this);
            }
        };
        display.timerExec(30000, this.refreshTimer);
        this.refreshData();
    }

    private void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        ConsoleJob job = new ConsoleJob("Get DCI values for history graph", null, "org.netxms.ui.eclipse.dashboard", "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Date from = new Date(System.currentTimeMillis() - 3600000L);
                final Date to = new Date(System.currentTimeMillis());
                DashboardDciInfo[] dciList = LineChartElement.this.config.getDciList();
                int i = 0;
                while (i < dciList.length) {
                    final DciData data = LineChartElement.this.session.getCollectedData(dciList[i].nodeId, dciList[i].dciId, from, to, 0);
                    final int index = i++;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!LineChartElement.this.chart.isDisposed()) {
                                LineChartElement.this.chart.setTimeRange(from, to);
                                LineChartElement.this.chart.updateParameter(index, data, false);
                            }
                        }
                    });
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!LineChartElement.this.chart.isDisposed()) {
                            LineChartElement.this.chart.refresh();
                        }
                        LineChartElement.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get DCI values for history graph";
            }

            protected void jobFailureHandler() {
                LineChartElement.this.updateInProgress = false;
                super.jobFailureHandler();
            }
        };
        job.setUser(false);
        job.start();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (hHint == -1 && size.y < 210) {
            size.y = 210;
        }
        return size;
    }
}

