/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.widgets.DataComparisonBirtChart;
import org.netxms.ui.eclipse.dashboard.widgets.ComparisonChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardDciInfo;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DialChartConfig;

public class DialChartElement
extends ComparisonChartElement {
    private DialChartConfig config;

    public DialChartElement(DashboardControl parent, DashboardElement element) {
        super(parent, element);
        try {
            this.config = DialChartConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new DialChartConfig();
        }
        this.chart = new DataComparisonBirtChart((Composite)this, 0, 4);
        this.chart.setTitleVisible(true);
        this.chart.setChartTitle(this.config.getTitle());
        this.chart.setLegendVisible(false);
        this.chart.setDialMaxValue(this.config.getMaxValue());
        this.chart.setDialRedZone(this.config.getRedZone());
        this.chart.setDialYellowZone(this.config.getYellowZone());
        int index = 0;
        DashboardDciInfo[] dashboardDciInfoArray = this.config.getDciList();
        int n = dashboardDciInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DashboardDciInfo dci = dashboardDciInfoArray[n2];
            this.chart.addParameter(new GraphItem(dci.nodeId, dci.dciId, 0, 0, Long.toString(dci.dciId), dci.getName()), 0.0);
            int color = dci.getColorAsInt();
            if (color != -1) {
                this.chart.setPaletteEntry(index++, new ChartColor(color));
            }
            ++n2;
        }
        this.chart.initializationComplete();
        this.startRefreshTimer();
    }

    @Override
    protected DashboardDciInfo[] getDciList() {
        return this.config.getDciList();
    }
}

