/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class AddUsmCredDialog
extends Dialog {
    private LabeledText name;
    private LabeledText authPasswd;
    private LabeledText privPasswd;
    private Combo authMethod;
    private Combo privMethod;
    private SnmpUsmCredential value;

    public AddUsmCredDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Add SNMP USM Credentials");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("User name");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        this.authMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Authentication", (Object)"WidgetHelper::default_layout_data");
        this.authMethod.add("NONE");
        this.authMethod.add("MD5");
        this.authMethod.add("SHA1");
        this.authMethod.select(2);
        this.privMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Encryption", (Object)"WidgetHelper::default_layout_data");
        this.privMethod.add("NONE");
        this.privMethod.add("DES");
        this.privMethod.add("AES");
        this.privMethod.select(2);
        this.authPasswd = new LabeledText(dialogArea, 0);
        this.authPasswd.setLabel("Authentication password");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.authPasswd.setLayoutData((Object)gd);
        this.privPasswd = new LabeledText(dialogArea, 0);
        this.privPasswd.setLabel("Encryption password");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.privPasswd.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.value = new SnmpUsmCredential();
        this.value.setName(this.name.getText().trim());
        this.value.setAuthMethod(this.authMethod.getSelectionIndex());
        this.value.setPrivMethod(this.privMethod.getSelectionIndex());
        this.value.setAuthPassword(this.authPasswd.getText());
        this.value.setPrivPassword(this.privPasswd.getText());
        super.okPressed();
    }

    public SnmpUsmCredential getValue() {
        return this.value;
    }
}

