/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.layout;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.LabelLimiter;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;

public final class LayoutManager {
    private static final IGObjectFactory goFactory = GObjectFactory.instance();

    public LayoutManager(Block _blRoot) {
    }

    private void initTitleSizeLimit(IDisplayServer xs, Chart cm, RunTimeContext rtc, Bounds bo) {
        bo = goFactory.scaleBounds(bo, (double)xs.getDpiResolution() / 72.0);
        bo.adjust(cm.getTitle().getInsets());
        int iTitleAnchor = cm.getTitle().getAnchor().getValue();
        LabelLimiter lbLimiter = null;
        lbLimiter = iTitleAnchor == 2 || iTitleAnchor == 6 ? new LabelLimiter(bo.getWidth() * 0.5, bo.getHeight(), 0.0) : new LabelLimiter(bo.getWidth(), bo.getHeight() * 0.5, 0.0);
        Map<Label, LabelLimiter> mapLimiter = rtc.getState(RunTimeContext.StateKey.LABEL_LIMITER_LOOKUP_KEY);
        mapLimiter.put(cm.getTitle().getLabel(), lbLimiter);
    }

    private void doLayout_tmp(IDisplayServer xs, Chart cm, Bounds boFull, RunTimeContext rtc) throws ChartException {
        rtc.putState(RunTimeContext.StateKey.LABEL_LIMITER_LOOKUP_KEY, new HashMap());
        Legend lg = cm.getLegend();
        Position lgPos = lg.getPosition();
        new ChartLayout(xs, cm, boFull, rtc).compute(lgPos);
        Block bl = cm.getBlock();
        bl.setBounds(boFull);
        Plot pl = cm.getPlot();
        TitleBlock tb = cm.getTitle();
        for (Block cbl : bl.getChildren()) {
            if (cbl == lg || cbl == pl || cbl == tb) continue;
            this.layoutBlock(xs, cm, bl.getBounds(), bl.getInsets(), cbl, rtc);
        }
        for (Block cbl : lg.getChildren()) {
            this.layoutBlock(xs, cm, lg.getBounds(), lg.getInsets(), cbl, rtc);
        }
        for (Block cbl : tb.getChildren()) {
            this.layoutBlock(xs, cm, tb.getBounds(), tb.getInsets(), cbl, rtc);
        }
        for (Block cbl : pl.getChildren()) {
            this.layoutBlock(xs, cm, pl.getBounds(), pl.getInsets(), cbl, rtc);
        }
    }

    private void layoutBlock(IDisplayServer xs, Chart cm, Bounds bo, Insets ins, Block block, RunTimeContext rtc) throws ChartException {
        if (!block.isSetAnchor()) {
            return;
        }
        Bounds cbo = block.getBounds();
        if (cbo == null) {
            cbo = goFactory.createBounds(0.0, 0.0, 0.0, 0.0);
        } else if (cbo.getLeft() != 0.0 || cbo.getTop() != 0.0 || cbo.getWidth() != 0.0 || cbo.getHeight() != 0.0) {
            return;
        }
        bo = goFactory.adjusteBounds(bo, ins);
        Anchor anchor = block.getAnchor();
        if (rtc != null && rtc.isRightToLeft()) {
            switch (anchor.getValue()) {
                case 2: {
                    anchor = Anchor.WEST_LITERAL;
                    break;
                }
                case 1: {
                    anchor = Anchor.NORTH_WEST_LITERAL;
                    break;
                }
                case 3: {
                    anchor = Anchor.SOUTH_WEST_LITERAL;
                    break;
                }
                case 6: {
                    anchor = Anchor.EAST_LITERAL;
                    break;
                }
                case 7: {
                    anchor = Anchor.NORTH_EAST_LITERAL;
                    break;
                }
                case 5: {
                    anchor = Anchor.SOUTH_EAST_LITERAL;
                }
            }
        }
        Size sz = block.getPreferredSize(xs, cm, rtc);
        cbo.setWidth(sz.getWidth());
        cbo.setHeight(sz.getHeight());
        switch (anchor.getValue()) {
            case 2: {
                cbo.setLeft(bo.getLeft() + bo.getWidth() - sz.getWidth());
                cbo.setTop(bo.getTop() + (bo.getHeight() - sz.getHeight()) / 2.0);
                break;
            }
            case 0: {
                cbo.setLeft(bo.getLeft() + (bo.getWidth() - sz.getWidth()) / 2.0);
                cbo.setTop(bo.getTop());
                break;
            }
            case 1: {
                cbo.setLeft(bo.getLeft() + bo.getWidth() - sz.getWidth());
                cbo.setTop(bo.getTop());
                break;
            }
            case 7: {
                cbo.setLeft(bo.getLeft());
                cbo.setTop(bo.getTop());
                break;
            }
            case 4: {
                cbo.setLeft(bo.getLeft() + (bo.getWidth() - sz.getWidth()) / 2.0);
                cbo.setTop(bo.getTop() + bo.getHeight() - sz.getHeight());
                break;
            }
            case 3: {
                cbo.setLeft(bo.getLeft() + bo.getWidth() - sz.getWidth());
                cbo.setTop(bo.getTop() + bo.getHeight() - sz.getHeight());
                break;
            }
            case 5: {
                cbo.setLeft(bo.getLeft());
                cbo.setTop(bo.getTop() + bo.getHeight() - sz.getHeight());
                break;
            }
            case 6: {
                cbo.setLeft(bo.getLeft());
                cbo.setTop(bo.getTop() + (bo.getHeight() - sz.getHeight()) / 2.0);
            }
        }
        block.setBounds(cbo);
    }

    public void doLayout(IDisplayServer xs, Chart cm, Bounds bo, RunTimeContext rtc) throws ChartException {
        this.doLayout_tmp(xs, cm, bo, rtc);
    }

    class ChartLayout {
        private Bounds bo;
        private Size szTitle;
        private Bounds boPlot;
        private Bounds boLegend;
        private Bounds boTitle;
        private Anchor plotAnchor;
        double plotWidthHint = -1.0;
        double plotHeightHint = -1.0;
        private Size szLegend;
        private Anchor titleAnchor;

        ChartLayout(IDisplayServer xs, Chart cm, Bounds boFull, RunTimeContext rtc) throws ChartException {
            boolean isRightToLeft = rtc.isRightToLeft();
            Block bl = cm.getBlock();
            bl.setBounds(boFull);
            Insets ins = bl.getInsets();
            this.bo = goFactory.adjusteBounds(boFull, ins);
            Legend lg = cm.getLegend();
            Plot pl = cm.getPlot();
            LayoutManager.this.initTitleSizeLimit(xs, cm, rtc, this.bo);
            TitleBlock tb = cm.getTitle();
            this.szTitle = !tb.isVisible() ? SizeImpl.create(0.0, 0.0) : tb.getPreferredSize(xs, cm, rtc);
            this.boPlot = pl.getBounds();
            this.boLegend = lg.getBounds();
            this.boTitle = tb.getBounds();
            this.titleAnchor = tb.getAnchor();
            this.boTitle.setLeft(this.bo.getLeft());
            this.boTitle.setTop(this.bo.getTop());
            this.boTitle.setWidth(this.szTitle.getWidth());
            this.boTitle.setHeight(this.szTitle.getHeight());
            Size size = this.szLegend = !lg.isVisible() ? SizeImpl.create(0.0, 0.0) : lg.getPreferredSize(xs, cm, rtc);
            if (pl.isSetWidthHint()) {
                this.plotWidthHint = pl.getWidthHint();
            }
            if (pl.isSetHeightHint()) {
                this.plotHeightHint = pl.getHeightHint();
            }
            this.adjustPlotAnchor(isRightToLeft, pl);
        }

        private void adjustPlotAnchor(boolean isRightToLeft, Plot pl) {
            this.plotAnchor = pl.getAnchor();
            if (isRightToLeft) {
                switch (this.plotAnchor.getValue()) {
                    case 2: {
                        this.plotAnchor = Anchor.WEST_LITERAL;
                        break;
                    }
                    case 1: {
                        this.plotAnchor = Anchor.NORTH_WEST_LITERAL;
                        break;
                    }
                    case 3: {
                        this.plotAnchor = Anchor.SOUTH_WEST_LITERAL;
                        break;
                    }
                    case 6: {
                        this.plotAnchor = Anchor.EAST_LITERAL;
                        break;
                    }
                    case 7: {
                        this.plotAnchor = Anchor.NORTH_EAST_LITERAL;
                        break;
                    }
                    case 5: {
                        this.plotAnchor = Anchor.SOUTH_EAST_LITERAL;
                    }
                }
            }
        }

        void compute(Position pos) {
            switch (pos.getValue()) {
                case 4: {
                    this.doLayoutInside();
                    break;
                }
                case 3: 
                case 5: {
                    this.doLayoutOutside();
                    break;
                }
                case 2: {
                    this.doLayoutLeft();
                    break;
                }
                case 0: {
                    this.doLayoutAbove();
                    break;
                }
                case 1: {
                    this.doLayoutBelow();
                }
            }
        }

        private void doLayoutOutside() {
            this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.szLegend.getWidth() : this.plotWidthHint);
            this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() - this.szTitle.getHeight() : this.plotHeightHint);
            this.boLegend.setTop(this.bo.getTop());
            this.boLegend.setWidth(this.szLegend.getWidth());
            this.boLegend.setHeight(this.bo.getHeight() - this.szTitle.getHeight());
            double plotLeft = this.bo.getLeft();
            double plotTop = this.bo.getTop();
            switch (this.titleAnchor.getValue()) {
                case 2: {
                    this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.boLegend.getWidth() - this.szTitle.getWidth() : this.plotWidthHint);
                    this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() : this.plotHeightHint);
                    if (this.szTitle.getWidth() + this.boPlot.getWidth() + this.boLegend.getWidth() > this.bo.getWidth()) {
                        this.boLegend.setWidth(this.bo.getWidth() - this.boPlot.getWidth() - this.szTitle.getWidth());
                    }
                    this.boLegend.setHeight(this.bo.getHeight());
                    this.boTitle.setHeight(this.bo.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft() + this.boPlot.getWidth() + this.boLegend.getWidth());
                    break;
                }
                case 6: {
                    plotLeft = this.bo.getLeft() + this.szTitle.getWidth();
                    this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.boLegend.getWidth() - this.szTitle.getWidth() : this.plotWidthHint);
                    this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() : this.plotHeightHint);
                    this.boTitle.setHeight(this.bo.getHeight());
                    if (this.szTitle.getWidth() + this.boPlot.getWidth() + this.boLegend.getWidth() > this.bo.getWidth()) {
                        this.boLegend.setWidth(this.bo.getWidth() - this.boPlot.getWidth() - this.szTitle.getWidth());
                    }
                    this.boLegend.setHeight(this.bo.getHeight());
                    break;
                }
                case 4: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setWidth(this.bo.getWidth());
                    break;
                }
                case 3: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    break;
                }
                case 5: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft());
                    break;
                }
                case 0: {
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                    this.boLegend.setTop(this.bo.getTop() + this.szTitle.getHeight());
                    this.boTitle.setWidth(this.bo.getWidth());
                    break;
                }
                case 1: {
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                    this.boLegend.setTop(this.bo.getTop() + this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    break;
                }
                case 7: {
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                    this.boLegend.setTop(this.bo.getTop() + this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft());
                }
            }
            block10 : switch (this.titleAnchor.getValue()) {
                case 2: 
                case 6: {
                    switch (this.plotAnchor.getValue()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            plotLeft = plotLeft + this.bo.getWidth() - this.szTitle.getWidth() - this.boLegend.getWidth() - this.boPlot.getWidth();
                            break;
                        }
                        case 0: 
                        case 4: {
                            plotLeft += (this.bo.getWidth() - this.szTitle.getWidth() - this.boLegend.getWidth() - this.boPlot.getWidth()) / 2.0;
                        }
                    }
                    break;
                }
                default: {
                    switch (this.plotAnchor.getValue()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            plotLeft = plotLeft + this.bo.getWidth() - this.boLegend.getWidth() - this.boPlot.getWidth();
                            break block10;
                        }
                        case 0: 
                        case 4: {
                            plotLeft += (this.bo.getWidth() - this.boLegend.getWidth() - this.boPlot.getWidth()) / 2.0;
                        }
                    }
                }
            }
            block21 : switch (this.titleAnchor.getValue()) {
                case 2: 
                case 6: {
                    switch (this.plotAnchor.getValue()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            plotTop = plotTop + this.bo.getHeight() - this.boPlot.getHeight();
                            break;
                        }
                        case 2: 
                        case 6: {
                            plotTop += (this.bo.getHeight() - this.boPlot.getHeight()) / 2.0;
                        }
                    }
                    break;
                }
                default: {
                    switch (this.plotAnchor.getValue()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            plotTop = plotTop + this.bo.getHeight() - this.szTitle.getHeight() - this.boPlot.getHeight();
                            break block21;
                        }
                        case 2: 
                        case 6: {
                            plotTop += (this.bo.getHeight() - this.szTitle.getHeight() - this.boPlot.getHeight()) / 2.0;
                        }
                    }
                }
            }
            this.boPlot.setLeft(plotLeft);
            this.boPlot.setTop(plotTop);
            this.boLegend.setLeft(plotLeft + this.boPlot.getWidth());
        }

        private void doLayoutInside() {
            this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() : this.plotWidthHint);
            this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() - this.szTitle.getHeight() : this.plotHeightHint);
            double plotLeft = this.bo.getLeft();
            double plotTop = this.bo.getTop();
            switch (this.titleAnchor.getValue()) {
                case 2: {
                    this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.szTitle.getWidth() : this.plotWidthHint);
                    this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() : this.plotHeightHint);
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    this.boTitle.setHeight(this.bo.getHeight());
                    break;
                }
                case 6: {
                    plotLeft = this.bo.getLeft() + this.szTitle.getWidth();
                    this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.szTitle.getWidth() : this.plotWidthHint);
                    this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() : this.plotHeightHint);
                    this.boTitle.setHeight(this.bo.getHeight());
                    break;
                }
                case 4: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setWidth(this.bo.getWidth());
                    break;
                }
                case 3: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    break;
                }
                case 5: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft());
                    break;
                }
                case 0: {
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                    this.boTitle.setWidth(this.bo.getWidth());
                    break;
                }
                case 1: {
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    break;
                }
                case 7: {
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                    this.boTitle.setLeft(this.bo.getLeft());
                }
            }
            block10 : switch (this.titleAnchor.getValue()) {
                case 2: 
                case 6: {
                    switch (this.plotAnchor.getValue()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            plotLeft = plotLeft + this.bo.getWidth() - this.szTitle.getWidth() - this.boPlot.getWidth();
                            break;
                        }
                        case 0: 
                        case 4: {
                            plotLeft += (this.bo.getWidth() - this.szTitle.getWidth() - this.boPlot.getWidth()) / 2.0;
                        }
                    }
                    break;
                }
                default: {
                    switch (this.plotAnchor.getValue()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            plotLeft = plotLeft + this.bo.getWidth() - this.boPlot.getWidth();
                            break block10;
                        }
                        case 0: 
                        case 4: {
                            plotLeft += (this.bo.getWidth() - this.boPlot.getWidth()) / 2.0;
                        }
                    }
                }
            }
            block21 : switch (this.titleAnchor.getValue()) {
                case 2: 
                case 6: {
                    switch (this.plotAnchor.getValue()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            plotTop = plotTop + this.bo.getHeight() - this.boPlot.getHeight();
                            break;
                        }
                        case 2: 
                        case 6: {
                            plotTop += (this.bo.getHeight() - this.boPlot.getHeight()) / 2.0;
                        }
                    }
                    break;
                }
                default: {
                    switch (this.plotAnchor.getValue()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            plotTop = plotTop + this.bo.getHeight() - this.szTitle.getHeight() - this.boPlot.getHeight();
                            break block21;
                        }
                        case 2: 
                        case 6: {
                            plotTop += (this.bo.getHeight() - this.szTitle.getHeight() - this.boPlot.getHeight()) / 2.0;
                        }
                    }
                }
            }
            this.boPlot.setLeft(plotLeft);
            this.boPlot.setTop(plotTop);
            this.boLegend.set(0.0, 0.0, this.szLegend.getWidth(), this.szLegend.getHeight());
        }

        private void doLayoutBelow() {
            this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() : this.plotWidthHint);
            this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() - this.boTitle.getHeight() - this.szLegend.getHeight() : this.plotHeightHint);
            this.boLegend.setLeft(this.bo.getLeft());
            this.boLegend.setWidth(this.bo.getWidth());
            if (this.szTitle.getHeight() + this.boPlot.getHeight() + this.szLegend.getHeight() > this.bo.getHeight()) {
                this.boLegend.setHeight(this.bo.getHeight() - this.szTitle.getHeight() - this.boPlot.getHeight());
            } else {
                this.boLegend.setHeight(this.szLegend.getHeight());
            }
            double plotLeft = this.bo.getLeft();
            double plotTop = this.bo.getTop();
            switch (this.titleAnchor.getValue()) {
                case 2: {
                    this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.szTitle.getWidth() : this.plotWidthHint);
                    this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() - this.boLegend.getHeight() : this.plotHeightHint);
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    this.boTitle.setHeight(this.bo.getHeight());
                    this.boLegend.setWidth(this.bo.getWidth() - this.szTitle.getWidth());
                    break;
                }
                case 6: {
                    this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.szTitle.getWidth() : this.plotWidthHint);
                    this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() - this.boLegend.getHeight() : this.plotHeightHint);
                    this.boTitle.setHeight(this.bo.getHeight());
                    this.boLegend.setWidth(this.bo.getWidth() - this.szTitle.getWidth());
                    this.boLegend.setLeft(this.bo.getLeft() + this.szTitle.getWidth());
                    plotLeft = this.bo.getLeft() + this.szTitle.getWidth();
                    break;
                }
                case 4: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setWidth(this.bo.getWidth());
                    break;
                }
                case 3: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    break;
                }
                case 5: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft());
                    break;
                }
                case 0: {
                    this.boTitle.setWidth(this.bo.getWidth());
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                    break;
                }
                case 1: {
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                    break;
                }
                case 7: {
                    this.boTitle.setLeft(this.bo.getLeft());
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                }
            }
            block10 : switch (this.titleAnchor.getValue()) {
                case 2: 
                case 6: {
                    switch (this.plotAnchor.getValue()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            plotLeft = plotLeft + this.bo.getWidth() - this.szTitle.getWidth() - this.boPlot.getWidth();
                            break;
                        }
                        case 0: 
                        case 4: {
                            plotLeft += (this.bo.getWidth() - this.szTitle.getWidth() - this.boPlot.getWidth()) / 2.0;
                        }
                    }
                    break;
                }
                default: {
                    switch (this.plotAnchor.getValue()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            plotLeft = plotLeft + this.bo.getWidth() - this.boPlot.getWidth();
                            break block10;
                        }
                        case 0: 
                        case 4: {
                            plotLeft += (this.bo.getWidth() - this.boPlot.getWidth()) / 2.0;
                        }
                    }
                }
            }
            block21 : switch (this.titleAnchor.getValue()) {
                case 2: 
                case 6: {
                    switch (this.plotAnchor.getValue()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            plotTop = plotTop + this.bo.getHeight() - this.boLegend.getHeight() - this.boPlot.getHeight();
                            break;
                        }
                        case 2: 
                        case 6: {
                            plotTop += (this.bo.getHeight() - this.boLegend.getHeight() - this.boPlot.getHeight()) / 2.0;
                        }
                    }
                    break;
                }
                default: {
                    switch (this.plotAnchor.getValue()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            plotTop = plotTop + this.bo.getHeight() - this.szTitle.getHeight() - this.boLegend.getHeight() - this.boPlot.getHeight();
                            break block21;
                        }
                        case 2: 
                        case 6: {
                            plotTop += (this.bo.getHeight() - this.szTitle.getHeight() - this.boLegend.getHeight() - this.boPlot.getHeight()) / 2.0;
                        }
                    }
                }
            }
            this.boPlot.setLeft(plotLeft);
            this.boPlot.setTop(plotTop);
            this.boLegend.setTop(plotTop + this.boPlot.getHeight());
        }

        private void doLayoutAbove() {
            this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() : this.plotWidthHint);
            this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() - this.szTitle.getHeight() - this.szLegend.getHeight() : this.plotHeightHint);
            this.boLegend.setTop(this.bo.getTop());
            this.boLegend.setLeft(this.bo.getLeft());
            this.boLegend.setWidth(this.bo.getWidth());
            if (this.szTitle.getHeight() + this.boPlot.getHeight() + this.szLegend.getHeight() > this.bo.getHeight()) {
                this.boLegend.setHeight(this.bo.getHeight() - this.szTitle.getHeight() - this.boPlot.getHeight());
            } else {
                this.boLegend.setHeight(this.szLegend.getHeight());
            }
            double plotLeft = this.bo.getLeft();
            double plotTop = this.bo.getTop() + this.boLegend.getHeight();
            switch (this.titleAnchor.getValue()) {
                case 2: {
                    this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.szTitle.getWidth() : this.plotWidthHint);
                    this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() - this.boLegend.getHeight() : this.plotHeightHint);
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    this.boTitle.setHeight(this.bo.getHeight());
                    this.boLegend.setWidth(this.bo.getWidth() - this.szTitle.getWidth());
                    break;
                }
                case 6: {
                    this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.szTitle.getWidth() : this.plotWidthHint);
                    this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() - this.boLegend.getHeight() : this.plotHeightHint);
                    this.boTitle.setHeight(this.bo.getHeight());
                    this.boLegend.setWidth(this.bo.getWidth() - this.szTitle.getWidth());
                    this.boLegend.setLeft(this.bo.getLeft() + this.szTitle.getWidth());
                    plotLeft = this.bo.getLeft() + this.szTitle.getWidth();
                    break;
                }
                case 4: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setWidth(this.bo.getWidth());
                    break;
                }
                case 3: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    break;
                }
                case 5: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft());
                    break;
                }
                case 0: {
                    plotTop = this.bo.getTop() + this.boLegend.getHeight() + this.szTitle.getHeight();
                    this.boLegend.setTop(this.bo.getTop() + this.szTitle.getHeight());
                    this.boTitle.setWidth(this.bo.getWidth());
                    break;
                }
                case 1: {
                    plotTop = this.bo.getTop() + this.boLegend.getHeight() + this.szTitle.getHeight();
                    this.boLegend.setTop(this.bo.getTop() + this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    break;
                }
                case 7: {
                    plotTop = this.bo.getTop() + this.boLegend.getHeight() + this.szTitle.getHeight();
                    this.boLegend.setTop(this.bo.getTop() + this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft());
                }
            }
            block10 : switch (this.titleAnchor.getValue()) {
                case 2: 
                case 6: {
                    switch (this.plotAnchor.getValue()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            plotLeft = plotLeft + this.bo.getWidth() - this.szTitle.getWidth() - this.boPlot.getWidth();
                            break;
                        }
                        case 0: 
                        case 4: {
                            plotLeft += (this.bo.getWidth() - this.szTitle.getWidth() - this.boPlot.getWidth()) / 2.0;
                        }
                    }
                    break;
                }
                default: {
                    switch (this.plotAnchor.getValue()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            plotLeft = plotLeft + this.bo.getWidth() - this.boPlot.getWidth();
                            break block10;
                        }
                        case 0: 
                        case 4: {
                            plotLeft += (this.bo.getWidth() - this.boPlot.getWidth()) / 2.0;
                        }
                    }
                }
            }
            block21 : switch (this.titleAnchor.getValue()) {
                case 2: 
                case 6: {
                    switch (this.plotAnchor.getValue()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            plotTop = plotTop + this.bo.getHeight() - this.boLegend.getHeight() - this.boPlot.getHeight();
                            break;
                        }
                        case 2: 
                        case 6: {
                            plotTop += (this.bo.getHeight() - this.boLegend.getHeight() - this.boPlot.getHeight()) / 2.0;
                        }
                    }
                    break;
                }
                default: {
                    switch (this.plotAnchor.getValue()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            plotTop = plotTop + this.bo.getHeight() - this.szTitle.getHeight() - this.boLegend.getHeight() - this.boPlot.getHeight();
                            break block21;
                        }
                        case 2: 
                        case 6: {
                            plotTop += (this.bo.getHeight() - this.szTitle.getHeight() - this.boLegend.getHeight() - this.boPlot.getHeight()) / 2.0;
                        }
                    }
                }
            }
            this.boPlot.setLeft(plotLeft);
            this.boPlot.setTop(plotTop);
        }

        private void doLayoutLeft() {
            this.boLegend.setTop(this.bo.getTop());
            this.boLegend.setLeft(this.bo.getLeft());
            this.boLegend.setWidth(this.szLegend.getWidth());
            this.boLegend.setHeight(this.bo.getHeight() - this.szTitle.getHeight());
            this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.boLegend.getWidth() : this.plotWidthHint);
            this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() - this.szTitle.getHeight() : this.plotHeightHint);
            double plotLeft = this.bo.getLeft() + this.szLegend.getWidth();
            double plotTop = this.bo.getTop();
            switch (this.titleAnchor.getValue()) {
                case 2: {
                    this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.boLegend.getWidth() - this.szTitle.getWidth() : this.plotWidthHint);
                    this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() : this.plotHeightHint);
                    if (this.boLegend.getWidth() + this.boPlot.getWidth() + this.szTitle.getWidth() > this.bo.getWidth()) {
                        this.boLegend.setWidth(this.bo.getWidth() - this.boPlot.getWidth() - this.szTitle.getWidth());
                    }
                    this.boLegend.setHeight(this.bo.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft() + this.boPlot.getWidth() + this.boLegend.getWidth());
                    this.boTitle.setHeight(this.bo.getHeight());
                    plotLeft = this.bo.getLeft() + this.boLegend.getWidth();
                    break;
                }
                case 6: {
                    this.boPlot.setWidth(this.plotWidthHint < 0.0 ? this.bo.getWidth() - this.boLegend.getWidth() - this.szTitle.getWidth() : this.plotWidthHint);
                    this.boPlot.setHeight(this.plotHeightHint < 0.0 ? this.bo.getHeight() : this.plotHeightHint);
                    this.boTitle.setHeight(this.bo.getHeight());
                    this.boLegend.setLeft(this.bo.getLeft() + this.szTitle.getWidth());
                    if (this.boLegend.getWidth() + this.boPlot.getWidth() + this.szTitle.getWidth() > this.bo.getWidth()) {
                        this.boLegend.setWidth(this.bo.getWidth() - this.boPlot.getWidth() - this.szTitle.getWidth());
                    }
                    this.boLegend.setHeight(this.bo.getHeight());
                    plotLeft = this.bo.getLeft() + this.szTitle.getWidth() + this.boLegend.getWidth();
                    break;
                }
                case 4: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setWidth(this.bo.getWidth());
                    break;
                }
                case 3: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    break;
                }
                case 5: {
                    this.boTitle.setTop(this.bo.getTop() + this.bo.getHeight() - this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft());
                    break;
                }
                case 0: {
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                    this.boLegend.setTop(this.bo.getTop() + this.szTitle.getHeight());
                    this.boTitle.setWidth(this.bo.getWidth());
                    break;
                }
                case 1: {
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                    this.boLegend.setTop(this.bo.getTop() + this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft() + this.bo.getWidth() - this.szTitle.getWidth());
                    break;
                }
                case 7: {
                    plotTop = this.bo.getTop() + this.szTitle.getHeight();
                    this.boLegend.setTop(this.bo.getTop() + this.szTitle.getHeight());
                    this.boTitle.setLeft(this.bo.getLeft());
                }
            }
            block10 : switch (this.titleAnchor.getValue()) {
                case 2: 
                case 6: {
                    switch (this.plotAnchor.getValue()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            plotLeft = plotLeft + this.bo.getWidth() - this.szTitle.getWidth() - this.boLegend.getWidth() - this.boPlot.getWidth();
                            break;
                        }
                        case 0: 
                        case 4: {
                            plotLeft += (this.bo.getWidth() - this.szTitle.getWidth() - this.boLegend.getWidth() - this.boPlot.getWidth()) / 2.0;
                        }
                    }
                    break;
                }
                default: {
                    switch (this.plotAnchor.getValue()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            plotLeft = plotLeft + this.bo.getWidth() - this.boLegend.getWidth() - this.boPlot.getWidth();
                            break block10;
                        }
                        case 0: 
                        case 4: {
                            plotLeft += (this.bo.getWidth() - this.boLegend.getWidth() - this.boPlot.getWidth()) / 2.0;
                        }
                    }
                }
            }
            block21 : switch (this.titleAnchor.getValue()) {
                case 2: 
                case 6: {
                    switch (this.plotAnchor.getValue()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            plotTop = plotTop + this.bo.getHeight() - this.boPlot.getHeight();
                            break;
                        }
                        case 2: 
                        case 6: {
                            plotTop += (this.bo.getHeight() - this.boPlot.getHeight()) / 2.0;
                        }
                    }
                    break;
                }
                default: {
                    switch (this.plotAnchor.getValue()) {
                        case 3: 
                        case 4: 
                        case 5: {
                            plotTop = plotTop + this.bo.getHeight() - this.szTitle.getHeight() - this.boPlot.getHeight();
                            break block21;
                        }
                        case 2: 
                        case 6: {
                            plotTop += (this.bo.getHeight() - this.szTitle.getHeight() - this.boPlot.getHeight()) / 2.0;
                        }
                    }
                }
            }
            this.boPlot.setLeft(plotLeft);
            this.boPlot.setTop(plotTop);
        }
    }
}

