/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.internal.ZoomManager;
import org.netxms.client.GeoLocation;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ZoomAction;
import org.netxms.ui.eclipse.osm.tools.MapLoader;
import org.netxms.ui.eclipse.osm.tools.TileSet;

public class ExtendedGraphViewer
extends GraphViewer {
    private static final double[] zoomLevels = new double[]{0.1, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 2.5, 3.0, 4.0};
    private BackgroundFigure backgroundFigure;
    private Image backgroundImage = null;
    private GeoLocation backgroundLocation;
    private int backgroundZoom;
    private IFigure zestRootLayer;
    private boolean graphControlResized = false;

    public ExtendedGraphViewer(Composite composite, int style) {
        super(composite, style);
        this.getZoomManager().setZoomLevels(zoomLevels);
        this.backgroundFigure = new BackgroundFigure();
        this.backgroundFigure.setSize(10, 10);
        for (Object f : this.getGraphControl().getRootLayer().getChildren()) {
            if (!f.getClass().getName().equals("org.eclipse.zest.core.widgets.internal.ZestRootLayer")) continue;
            this.zestRootLayer = (IFigure)f;
        }
        this.getGraphControl().getRootLayer().add((IFigure)this.backgroundFigure, 0);
        final Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (ExtendedGraphViewer.this.getGraphControl().isDisposed()) {
                    return;
                }
                if (ExtendedGraphViewer.this.graphControlResized) {
                    ExtendedGraphViewer.this.backgroundFigure.setSize(10, 10);
                    ExtendedGraphViewer.this.graphControlResized = false;
                }
                ExtendedGraphViewer.this.reloadMapBackground();
            }
        };
        this.getGraphControl().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                ExtendedGraphViewer.this.graphControlResized = true;
                if (ExtendedGraphViewer.this.backgroundLocation != null) {
                    ExtendedGraphViewer.this.getGraphControl().getDisplay().timerExec(1000, timer);
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.zestRootLayer.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                if (ExtendedGraphViewer.this.backgroundLocation != null) {
                    ExtendedGraphViewer.this.getGraphControl().getDisplay().timerExec(1000, timer);
                }
            }
        });
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        if (image != null) {
            org.eclipse.swt.graphics.Rectangle r = image.getBounds();
            this.backgroundFigure.setSize(r.width, r.height);
        } else {
            this.backgroundFigure.setSize(10, 10);
        }
        this.backgroundLocation = null;
        this.getGraphControl().redraw();
    }

    public void setBackgroundImage(GeoLocation location, int zoom) {
        if (this.backgroundLocation != null && this.backgroundImage != null) {
            this.backgroundImage.dispose();
        }
        this.backgroundImage = null;
        this.backgroundLocation = location;
        this.backgroundZoom = zoom;
        this.backgroundFigure.setSize(10, 10);
        this.getGraphControl().redraw();
        this.reloadMapBackground();
    }

    private void reloadMapBackground() {
        org.eclipse.swt.graphics.Rectangle controlSize = this.getGraphControl().getClientArea();
        Rectangle rootLayerSize = this.zestRootLayer.getClientArea();
        final Point mapSize = new Point(Math.max(controlSize.width, rootLayerSize.width), Math.max(controlSize.height, rootLayerSize.height));
        ConsoleJob job = new ConsoleJob("Download map tiles", null, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final TileSet tiles = MapLoader.getAllTiles((Point)mapSize, (GeoLocation)ExtendedGraphViewer.this.backgroundLocation, (int)1, (int)ExtendedGraphViewer.this.backgroundZoom);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Rectangle rootLayerSize = ExtendedGraphViewer.this.zestRootLayer.getClientArea();
                        if (mapSize.x != rootLayerSize.width || mapSize.y != rootLayerSize.height) {
                            return;
                        }
                        if (mapSize.x > rootLayerSize.width) {
                            mapSize.x = rootLayerSize.width;
                        }
                        if (mapSize.y > rootLayerSize.height) {
                            mapSize.y = rootLayerSize.height;
                        }
                        ExtendedGraphViewer.this.backgroundFigure.setSize(mapSize.x, mapSize.y);
                        ExtendedGraphViewer.this.drawTiles(tiles);
                        ExtendedGraphViewer.this.getGraphControl().redraw();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot download map tiles";
            }
        };
        job.setUser(false);
        job.start();
    }

    private void drawTiles(TileSet tileSet) {
        if (this.backgroundLocation != null && this.backgroundImage != null) {
            this.backgroundImage.dispose();
        }
        if (tileSet == null || tileSet.tiles == null || tileSet.tiles.length == 0) {
            this.backgroundImage = null;
            return;
        }
        Image[][] tiles = tileSet.tiles;
        Dimension size = this.backgroundFigure.getSize();
        this.backgroundImage = new Image((Device)this.getGraphControl().getDisplay(), size.width, size.height);
        GC gc = new GC((Drawable)this.backgroundImage);
        int x = tileSet.xOffset;
        int y = tileSet.yOffset;
        int i = 0;
        while (i < tiles.length) {
            int j = 0;
            while (j < tiles[i].length) {
                gc.drawImage(tiles[i][j], x, y);
                if ((x += 256) >= size.width) {
                    x = tileSet.xOffset;
                    y += 256;
                }
                ++j;
            }
            ++i;
        }
        gc.dispose();
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        if (this.getInput() == null) {
            return;
        }
        if (element == this.getInput()) {
            this.getFactory().refreshGraph(this.getGraphControl());
        } else {
            this.getFactory().refresh(this.getGraphControl(), element, updateLabels);
        }
    }

    public void zoomIn() {
        this.getZoomManager().zoomIn();
    }

    public void zoomOut() {
        this.getZoomManager().zoomOut();
    }

    public Action[] createZoomActions() {
        ZoomManager zoomManager = this.getZoomManager();
        Action[] actions = new Action[zoomLevels.length];
        int i = 0;
        while (i < zoomLevels.length) {
            actions[i] = new ZoomAction(zoomLevels[i], zoomManager);
            if (zoomLevels[i] == 1.0) {
                actions[i].setChecked(true);
            }
            ++i;
        }
        return actions;
    }

    private class BackgroundFigure
    extends Figure {
        private BackgroundFigure() {
        }

        protected void paintFigure(Graphics gc) {
            if (ExtendedGraphViewer.this.backgroundImage != null) {
                gc.drawImage(ExtendedGraphViewer.this.backgroundImage, 0, 0);
            }
        }
    }
}

