/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views.helpers;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.netxms.client.datacollection.GraphItemStyle;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.ui.eclipse.charts.api.ChartPluginSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class GraphSettingsFactory {
    public static GraphSettings createDefault() {
        GraphSettings settings = new GraphSettings();
        IPreferenceStore preferenceStore = ChartPluginSharedData.getPreferenceStore();
        settings.setTooltipsEnabled(preferenceStore.getBoolean("Chart.ShowToolTips"));
        settings.setZoomEnabled(preferenceStore.getBoolean("Chart.EnableZoom"));
        settings.setBackgroundColor(ColorConverter.getColorFromPreferencesAsInt((IPreferenceStore)preferenceStore, (String)"Chart.Colors.Background"));
        settings.setSelectionColor(ColorConverter.getColorFromPreferencesAsInt((IPreferenceStore)preferenceStore, (String)"Chart.Colors.Selection"));
        GraphItemStyle[] styles = new GraphItemStyle[16];
        int i = 0;
        while (i < 16) {
            styles[i] = new GraphItemStyle(0, ColorConverter.getColorFromPreferencesAsInt((IPreferenceStore)preferenceStore, (String)("Chart.Colors.Data." + i)), 0, 0);
            ++i;
        }
        settings.setItemStyles(styles);
        return settings;
    }

    public static GraphSettings createFromMemento(IMemento memento) {
        GraphSettings settings = GraphSettingsFactory.createDefault();
        return settings;
    }
}

