/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ConditionDciInfo;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.Condition;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectDciDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.dialogs.ConditionDciEditDialog;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.DciListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ConditionData
extends PropertyPage {
    public static final int COLUMN_POSITION = 0;
    public static final int COLUMN_NODE = 1;
    public static final int COLUMN_METRIC = 2;
    public static final int COLUMN_FUNCTION = 3;
    private Condition object = null;
    private DciListLabelProvider labelProvider;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private List<ConditionDciInfo> dciList = null;
    private boolean isModified = false;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Condition)this.getElement().getAdapter(Condition.class);
        if (this.object == null) {
            return dialogArea;
        }
        this.dciList = new ArrayList<ConditionDciInfo>();
        for (ConditionDciInfo dci : this.object.getDciList()) {
            this.dciList.add(new ConditionDciInfo(dci));
        }
        this.labelProvider = new DciListLabelProvider(this.dciList);
        this.labelProvider.resolveDciNames(this.object.getDciList());
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{"Pos", "Node", "Parameter", "Function"};
        int[] columnWidths = new int[]{40, 130, 220, 80};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.disableSorting();
        this.viewer.setInput((Object)this.dciList.toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        gridData.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite leftButtons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gridData);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ConditionData.this.moveUp();
            }
        });
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ConditionData.this.moveDown();
            }
        });
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gridData);
        this.addButton = new Button(rightButtons, 8);
        this.addButton.setText("&Add...");
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ConditionData.this.addItem();
            }
        });
        this.editButton = new Button(rightButtons, 8);
        this.editButton.setText("&Modify...");
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ConditionData.this.editItem();
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(rightButtons, 8);
        this.deleteButton.setText("&Delete");
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ConditionData.this.deleteItems();
            }
        });
        this.deleteButton.setEnabled(false);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConditionData.this.editButton.notifyListeners(13, new Event());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ConditionData.this.viewer.getSelection();
                ConditionData.this.editButton.setEnabled(selection.size() == 1);
                ConditionData.this.deleteButton.setEnabled(selection.size() > 0);
                ConditionData.this.upButton.setEnabled(selection.size() == 1);
                ConditionData.this.downButton.setEnabled(selection.size() == 1);
            }
        });
        return dialogArea;
    }

    private void addItem() {
        SelectDciDialog dlg = new SelectDciDialog(this.getShell());
        if (dlg.open() == 0) {
            DciValue selection = dlg.getSelection();
            ConditionDciInfo dci = new ConditionDciInfo(selection.getNodeId(), selection.getId(), 0, 1);
            this.labelProvider.addCacheEntry(dci.getNodeId(), dci.getDciId(), selection.getDescription());
            this.dciList.add(dci);
            this.viewer.setInput((Object)this.dciList.toArray());
            this.isModified = true;
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)dci));
            this.editItem();
        }
    }

    private void editItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        ConditionDciInfo dci = (ConditionDciInfo)selection.getFirstElement();
        if (dci == null) {
            return;
        }
        ConditionDciEditDialog dlg = new ConditionDciEditDialog(this.getShell(), dci, this.labelProvider.getColumnText(dci, 1), this.labelProvider.getColumnText(dci, 2));
        if (dlg.open() == 0) {
            this.viewer.update((Object)dci, null);
            this.isModified = true;
        }
    }

    private void deleteItems() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.dciList.remove(o);
        }
        this.viewer.setInput((Object)this.dciList.toArray());
        this.isModified = true;
    }

    protected void applyChanges(final boolean isApply) {
        if (!this.isModified) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setDciList(this.dciList);
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Update condition's DCI list", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                ConditionData.this.isModified = false;
            }

            protected String getErrorMessage() {
                return "Cannot update condition's DCI list";
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ConditionData.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    private void moveUp() {
        ConditionDciInfo element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = (ConditionDciInfo)selection.getFirstElement())) > 0) {
            Collections.swap(this.dciList, index - 1, index);
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
            this.isModified = true;
        }
    }

    private void moveDown() {
        ConditionDciInfo element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = (ConditionDciInfo)selection.getFirstElement())) < this.dciList.size() - 1 && index >= 0) {
            Collections.swap(this.dciList, index + 1, index);
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }
}

